#if !defined(__RTK_CPUTAG_H__)

#include <linux/types.h>
#include <linux/if_ether.h>
#include <asm/byteorder.h>

#define TAG8_GET_PROT(x) (((x) >> 8) & 0xff)
#define TAG8_SET_PROT(x) (((x) & 0xff) << 8)
#define PROT_TAG8 0x4
#define TAG8_SET_ALLOW(x) (((x) & 0x1) << 15)
#define TAG8_GET_TX(x) ((x) & 0x7)
#define TAG8_SET_RX(x) ((x) & 0x3ff)

#define TAG4_GET_PROT(x) (((x) >> 8) & 0xff)
#define PROT_TAG4 0x4
#define TAG4_SET_PROT(x) (((x) & 0xff) << 8)
#define TAG4_GET_TX(x) ((x) & 0x7)
#define TAG4_SET_RX(x) ((x) & 0xff)

static inline int rtk_ctag8_is_valid(u8 *p)
{
	u16 *tag = (u16 *)p;

	if (ntohs(tag[0]) != ETH_P_REALTEK)
		return 0;

	if (TAG8_GET_PROT(ntohs(tag[1])) != PROT_TAG8)
		return 0;

	return 1;
}

static inline u8 rtk_ctag8_get_value(u8 *p)
{
	u16 *tag = (u16 *)p;

	return TAG8_GET_TX(ntohs(tag[3]));
}

static inline void rtk_ctag8_write(u8 *p, u16 ctag)
{
	u16 *tag = (u16 *)p;

	tag[0] = htons(ETH_P_REALTEK);
	tag[1] = htons(TAG8_SET_PROT(PROT_TAG8));	/* reason=0 */
	tag[2] = 0;	/* FID_EN/PRI_EN/KEEP/LEARN_DIS=0 */
	tag[3] = htons(TAG8_SET_ALLOW(1) | TAG8_SET_RX(ctag));
}

static inline int rtk_ctag4_is_valid(u8 *p)
{
	u16 *tag = (u16 *)p;

	if (ntohs(tag[0]) != ETH_P_REALTEK)
		return 0;

	if (TAG4_GET_PROT(ntohs(tag[1])) != PROT_TAG4)
		return 0;

	return 1;
}

static inline u8 rtk_ctag4_get_value(u8 *p)
{
	u16 *tag = (u16 *)p;

	return TAG4_GET_TX(ntohs(tag[1]));
}

static inline void rtk_ctag4_write(u8 *p, u16 ctag)
{
	u16 *tag = (u16 *)p;
	u16 prot;

	tag[0] = htons(ETH_P_REALTEK);
	prot = TAG4_SET_PROT(PROT_TAG4);
	tag[1] = htons(prot | TAG4_SET_RX(ctag));
}
#endif	/* __RTK_CPUTAG_H__ */
