#ifndef _RTL8367SC_H
#define _RTL8367SC_H

#define RTL8367SC_DRIVER_NAME	"rtl8367sc"

enum rtl8367_port_speed {
	RTL8367_PORT_SPEED_10 = 0,
	RTL8367_PORT_SPEED_100,
	RTL8367_PORT_SPEED_1000,
};

struct rtl8367_port_ability {
	int force_mode;
	int nway;
	int txpause;
	int rxpause;
	int link;
	int duplex;
	enum rtl8367_port_speed speed;
};

enum rtl8367_extif_mode {
	RTL8367_EXTIF_MODE_DISABLED = 0,
	RTL8367_EXTIF_MODE_RGMII,
	RTL8367_EXTIF_MODE_MII_MAC,
	RTL8367_EXTIF_MODE_MII_PHY,
	RTL8367_EXTIF_MODE_TMII_MAC,
	RTL8367_EXTIF_MODE_TMII_PHY,
	RTL8367_EXTIF_MODE_GMII,
	RTL8367_EXTIF_MODE_RGMII_33V,
};

struct rtl8367_extif_config {
	unsigned int txdelay;
	unsigned int rxdelay;
	enum rtl8367_extif_mode mode;
	struct rtl8367_port_ability ability;
};

struct rtl8367_platform_data {
	const char *mdio_name;
	void (*hw_reset)(bool active);

	struct rtl8367_extif_config *extif0_cfg;
	struct rtl8367_extif_config *extif1_cfg;
};

#endif /*  _RTL8367SC_H */
