/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2023-2024, Qualcomm Innovation Center, Inc. All rights reserved.
 *
 */
#ifndef _MACH_SYSMAP_IPQ5424_H
#define _MACH_SYSMAP_IPQ5424_H

/* GCC clock control registers */
#define GCC_QUPV3_UART0_CMD_RCGR			(0x0202C)
#define GCC_QUPV3_UART0_CFG_RCGR			(0x02030)
#define GCC_QUPV3_UART0_M				(0x02034)
#define GCC_QUPV3_UART0_N				(0x02038)
#define GCC_QUPV3_UART0_D				(0x0203C)
#define GCC_QUPV3_UART0_CBCR				(0x02040)
#define GCC_QUPV3_UART1_CMD_RCGR			(0x0302C)
#define GCC_QUPV3_UART1_CFG_RCGR			(0x03030)
#define GCC_QUPV3_UART1_M				(0x03034)
#define GCC_QUPV3_UART1_N				(0x03038)
#define GCC_QUPV3_UART1_D				(0x0303C)
#define GCC_QUPV3_UART1_CBCR				(0x03040)
#define GCC_QUPV3_I2C0_CMD_RCGR				(0x02018)
#define GCC_QUPV3_I2C0_CFG_RCGR				(0x0201C)
#define GCC_QUPV3_I2C0_DIV_CDIVR			(0x02020)
#define GCC_QUPV3_I2C0_CBCR				(0x02024)
#define GCC_QUPV3_I2C1_CMD_RCGR				(0x03018)
#define GCC_QUPV3_I2C1_CFG_RCGR				(0x0301C)
#define GCC_QUPV3_I2C1_DIV_CDIVR			(0x03020)
#define GCC_QUPV3_I2C1_CBCR				(0x03024)
#define GCC_QUPV3_SPI0_CMD_RCGR				(0x04004)
#define GCC_QUPV3_SPI0_CFG_RCGR				(0x04008)
#define GCC_QUPV3_SPI0_M				(0x0400C)
#define GCC_QUPV3_SPI0_N				(0x04010)
#define GCC_QUPV3_SPI0_D				(0x04014)
#define GCC_QUPV3_SPI0_CBCR				(0x04020)
#define GCC_QUPV3_SPI1_CMD_RCGR				(0x05004)
#define GCC_QUPV3_SPI1_CFG_RCGR				(0x05008)
#define GCC_QUPV3_SPI1_M				(0x0500C)
#define GCC_QUPV3_SPI1_N				(0x05010)
#define GCC_QUPV3_SPI1_D				(0x05014)
#define GCC_QUPV3_SPI1_CBCR				(0x05020)
#define GCC_NSSNOC_MEMNOC_BFDCD_CMD_RCGR		(0x17004)
#define GCC_NSSNOC_MEMNOC_BFDCD_CFG_RCGR		(0x17008)
#define GCC_NSSNOC_MEMNOC_CBCR				(0x17024)
#define GCC_NSSNOC_SNOC_CBCR				(0x17028)
#define GCC_NSSCFG_CBCR					(0x1702C)
#define GCC_NSSNOC_NSSCC_CBCR				(0x17030)
#define GCC_NSSCC_CBCR					(0x17034)
#define GCC_MDIO_AHB_CBCR				(0x17040)
#define GCC_UNIPHY0_SYS_CBCR				(0x17048)
#define GCC_UNIPHY0_AHB_CBCR				(0x1704C)
#define GCC_UNIPHY1_SYS_CBCR				(0x17058)
#define GCC_UNIPHY1_AHB_CBCR				(0x1705C)
#define GCC_UNIPHY2_SYS_CBCR				(0x17068)
#define GCC_UNIPHY2_AHB_CBCR				(0x1706C)
#define GCC_NSSNOC_SNOC_1_CBCR				(0x1707C)
#define GCC_NSSNOC_MEMNOC_1_CBCR			(0x17084)
#define GCC_SYSTEM_NOC_BFDCD_CMD_RCGR			(0x2E004)
#define GCC_SYSTEM_NOC_BFDCD_CFG_RCGR			(0x2E008)
#define GCC_PCNOC_BFDCD_CMD_RCGR			(0x31004)
#define GCC_PCNOC_BFDCD_CFG_RCGR			(0x31008)
#define SDCC1_APPS_CMD_RCGR				(0x33004)
#define SDCC1_APPS_CFG_RCGR				(0x33008)
#define SDCC1_APPS_M					(0x3300C)
#define SDCC1_APPS_N					(0x33010)
#define SDCC1_APPS_D					(0x33014)
#define GCC_SDCC1_APPS_CBCR				(0x3302C)
#define GCC_SDCC1_AHB_CBCR				(0x3303C)
#define GCC_IM_SLEEP_CBCR				(0x34020)
#define GCC_CMN_12GPLL_AHB_CBCR				(0x3A004)
#define GCC_CMN_12GPLL_SYS_CBCR				(0x3A008)

#define QUPV3_SRC_SEL_GPLL0_OUT_MAIN			(1 << 8)
#define QUPV3_SRC_SEL_GPLL0_OUT_MAIN_DIV		(1 << 10)
#define USB0_SRC_SEL_XO					(0 << 8)
#define USB0_SRC_SEL_GPLL0_OUT_MAIN			(1 << 8)
#define USB0_SRC_SEL_GPLL4_OUT_AUX			(1 << 8)
#define SDCC1_SRC_SEL_GPLL2_OUT_MAIN			(2 << 8)
#define SDCC1_SRC_SEL_GPLL0_OUT_MAIN			(1 << 8)
#define PCNOC_BFDCD_SRC_SEL_GPLL0_OUT_MAIN		(1 << 8)
#define SYSTEM_NOC_BFDCD_SRC_SEL_GPLL4_OUT_MAIN		(2 << 8)
#define NSSNOC_MEMNOC_BFDCD_SRC_SEL_NSS_CMN_CLK		(1 << 8)

/* PCIE clock control registers */
#define GCC_PCIE_AUX_CMD_RCGR				0x28004
#define GCC_PCIE_AUX_CFG_RCGR				0x28008
#define GCC_PCIE_AUX_M					0x2800C
#define GCC_PCIE_AUX_N					0x28010
#define GCC_PCIE_AUX_D					0x28014
#define GCC_PCIE0_AXI_M_CMD_RCGR 			0x28018
#define GCC_PCIE0_AXI_M_CFG_RCGR			0x2801C
#define GCC_PCIE1_AXI_M_CMD_RCGR 			0x29018
#define GCC_PCIE1_AXI_M_CFG_RCGR			0x2901C
#define GCC_PCIE2_AXI_M_CMD_RCGR 			0x2A018
#define GCC_PCIE2_AXI_M_CFG_RCGR			0x2A01C
#define GCC_PCIE3_AXI_M_CMD_RCGR 			0x2B018
#define GCC_PCIE3_AXI_M_CFG_RCGR			0x2B01C
#define GCC_PCIE0_AXI_S_CMD_RCGR			0x28020
#define GCC_PCIE0_AXI_S_CFG_RCGR			0x28024
#define GCC_PCIE1_AXI_S_CMD_RCGR			0x29020
#define GCC_PCIE1_AXI_S_CFG_RCGR			0x29024
#define GCC_PCIE2_AXI_S_CMD_RCGR			0x2A020
#define GCC_PCIE2_AXI_S_CFG_RCGR			0x2A024
#define GCC_PCIE3_AXI_S_CMD_RCGR			0x2B020
#define GCC_PCIE3_AXI_S_CFG_RCGR			0x2B024
#define GCC_PCIE0_RCHNG_CFG_RCGR			0x2802C
#define GCC_PCIE0_RCHNG_CMD_RCGR			0x28028
#define GCC_PCIE1_RCHNG_CFG_RCGR			0x2902C
#define GCC_PCIE1_RCHNG_CMD_RCGR			0x29028
#define GCC_PCIE2_RCHNG_CFG_RCGR			0x2A02C
#define GCC_PCIE2_RCHNG_CMD_RCGR			0x2A028
#define GCC_PCIE3_RCHNG_CFG_RCGR			0x2B02C
#define GCC_PCIE3_RCHNG_CMD_RCGR			0x2B028
#define PCIE_GPLL0_OUT_AUX				(2 << 8)
#define PCIE_GPLL4_OUT_MAIN				(2 << 8)
#define PCIE_GPLL0_OUT_MAIN				(1 << 8)
#define GCC_PCIE0_AHB_CBCR				0x28030
#define GCC_PCIE0_AUX_CBCR				0x28070
#define GCC_PCIE0_AXI_M_CBCR				0x28038
#define GCC_PCIE0_AXI_S_BRIDGE_CBCR			0x28048
#define GCC_PCIE0_AXI_S_CBCR				0x28040
#define GCC_PCIE0_PIPE_CBCR				0x28068
#define GCC_PCIE1_AHB_CBCR				0x29030
#define GCC_PCIE1_AUX_CBCR				0x29074
#define GCC_PCIE1_AXI_M_CBCR				0x29038
#define GCC_PCIE1_AXI_S_BRIDGE_CBCR			0x29048
#define GCC_PCIE1_AXI_S_CBCR				0x29040
#define GCC_PCIE1_PIPE_CBCR				0x29068
#define GCC_PCIE2_AHB_CBCR				0x2A030
#define GCC_PCIE2_AUX_CBCR				0x2A078
#define GCC_PCIE2_AXI_M_CBCR				0x2A038
#define GCC_PCIE2_AXI_S_BRIDGE_CBCR			0x2A048
#define GCC_PCIE2_AXI_S_CBCR				0x2A040
#define GCC_PCIE2_PIPE_CBCR				0x2A068
#define GCC_PCIE3_AHB_CBCR				0x2B030
#define GCC_PCIE3_AUX_CBCR				0x2B07C
#define GCC_PCIE3_AXI_M_CBCR				0x2B038
#define GCC_PCIE3_AXI_S_BRIDGE_CBCR			0x2B048
#define GCC_PCIE3_AXI_S_CBCR				0x2B040
#define GCC_PCIE3_PIPE_CBCR				0x2B068
#define GCC_CNOC_PCIE0_1LANE_S_CBCR			0x31088
#define GCC_CNOC_PCIE1_1LANE_S_CBCR			0x3108C
#define GCC_CNOC_PCIE2_2LANE_S_CBCR			0x31090
#define GCC_CNOC_PCIE3_2LANE_S_CBCR			0x31094
#define GCC_ANOC_PCIE0_1LANE_M_CBCR			0x2E07C
#define GCC_ANOC_PCIE1_1LANE_M_CBCR			0x2E084
#define GCC_ANOC_PCIE2_2LANE_M_CBCR			0x2E080
#define GCC_ANOC_PCIE3_2LANE_M_CBCR			0x2E090

/* USB clock control registers */
#define GCC_USB0_MASTER_CMD_RCGR			(0x2C004)
#define GCC_USB0_MASTER_CFG_RCGR			(0x2C008)
#define GCC_USB0_MASTER_M				(0x2C00C)
#define GCC_USB0_MASTER_N				(0x2C010)
#define GCC_USB0_MASTER_D				(0x2C014)
#define GCC_USB0_AUX_CMD_RCGR				(0x2C018)
#define GCC_USB0_AUX_CFG_RCGR				(0x2C01C)
#define GCC_USB0_AUX_M					(0x2C020)
#define GCC_USB0_AUX_N					(0x2C024)
#define GCC_USB0_AUX_D					(0x2C028)
#define GCC_USB0_MOCK_UTMI_CMD_RCGR			(0x2C02C)
#define GCC_USB0_MOCK_UTMI_CFG_RCGR			(0x2C030)
#define GCC_USB0_MOCK_UTMI_M				(0x2C034)
#define GCC_USB0_MOCK_UTMI_N				(0x2C038)
#define GCC_USB0_MOCK_UTMI_D				(0x2C03C)
#define GCC_USB0_MOCK_UTMI_DIV_CDIVR			(0x2C040)
#define GCC_USB1_MOCK_UTMI_CMD_RCGR			(0x3C004)
#define GCC_USB1_MOCK_UTMI_CFG_RCGR			(0x3C008)
#define GCC_USB1_MOCK_UTMI_M				(0x3C00C)
#define GCC_USB1_MOCK_UTMI_N				(0x3C010)
#define GCC_USB1_MOCK_UTMI_D				(0x3C014)
#define GCC_USB1_MOCK_UTMI_DIV_CDIVR			(0x3C018)

#define GCC_USB0_MASTER_CBCR				(0x2C044)
#define GCC_USB0_AUX_CBCR				(0x2C04C)
#define GCC_USB0_MOCK_UTMI_CBCR				(0x2C050)
#define GCC_USB0_PIPE_CBCR				(0x2C054)
#define GCC_USB0_SLEEP_CBCR				(0x2C058)
#define GCC_USB0_PHY_CFG_AHB_CBCR			(0x2C05C)
#define GCC_CNOC_USB_CBCR				(0x310A8)
#define GCC_USB1_PHY_CFG_AHB_CBCR			(0x3C01C)
#define GCC_USB1_SLEEP_CBCR				(0x3C020)
#define GCC_USB1_MOCK_UTMI_CBCR				(0x3C024)
#define GCC_USB1_MASTER_CBCR				(0x3C028)

/* NSS clock control registers */
#define NSS_CC_PPE_SWITCH_IPE_CBCR			(0x00400)
#define NSS_CC_PPE_SWITCH_BTQ_CBCR			(0x00408)
#define NSS_CC_PPE_SWITCH_CBCR				(0x00410)
#define NSS_CC_PPE_EDMA_CBCR				(0x0041C)
#define NSS_CC_PPE_EDMA_CFG_CBCR			(0x00424)
#define NSS_CC_PORT1_MAC_CBCR				(0x00428)
#define NSS_CC_PORT2_MAC_CBCR				(0x00430)
#define NSS_CC_PORT3_MAC_CBCR				(0x00438)
#define NSS_CC_NSSNOC_PPE_CBCR				(0x00440)
#define NSS_CC_NSSNOC_PPE_CFG_CBCR			(0x00444)
#define NSS_CC_PORT1_RX_CMD_RCGR			(0x004B4)
#define NSS_CC_PORT1_RX_CFG_RCGR			(0x004B8)
#define NSS_CC_PORT1_RX_DIV_CDIVR			(0x004BC)
#define NSS_CC_PORT1_TX_CMD_RCGR			(0x004C0)
#define NSS_CC_PORT1_TX_CFG_RCGR			(0x004C4)
#define NSS_CC_PORT1_TX_DIV_CDIVR			(0x004C8)
#define NSS_CC_PORT2_RX_CMD_RCGR			(0x004CC)
#define NSS_CC_PORT2_RX_CFG_RCGR			(0x004D0)
#define NSS_CC_PORT2_RX_DIV_CDIVR			(0x004D4)
#define NSS_CC_PORT2_TX_CMD_RCGR			(0x004D8)
#define NSS_CC_PORT2_TX_CFG_RCGR			(0x004DC)
#define NSS_CC_PORT2_TX_DIV_CDIVR			(0x004E0)
#define NSS_CC_PORT3_RX_CMD_RCGR			(0x004E4)
#define NSS_CC_PORT3_RX_CFG_RCGR			(0x004E8)
#define NSS_CC_PORT3_RX_DIV_CDIVR			(0x004EC)
#define NSS_CC_PORT3_TX_CMD_RCGR			(0x004F0)
#define NSS_CC_PORT3_TX_CFG_RCGR			(0x004F4)
#define NSS_CC_PORT3_TX_DIV_CDIVR			(0x004F8)
#define NSS_CC_PORT1_RX_CBCR				(0x004FC)
#define NSS_CC_PORT1_TX_CBCR				(0x00504)
#define NSS_CC_PORT2_RX_CBCR				(0x0050C)
#define NSS_CC_PORT2_TX_CBCR				(0x00514)
#define NSS_CC_PORT3_RX_CBCR				(0x0051C)
#define NSS_CC_PORT3_TX_CBCR				(0x00524)
#define NSS_CC_UNIPHY_PORT1_RX_CBCR			(0x0057C)
#define NSS_CC_UNIPHY_PORT1_TX_CBCR			(0x00580)
#define NSS_CC_UNIPHY_PORT2_RX_CBCR			(0x00584)
#define NSS_CC_UNIPHY_PORT2_TX_CBCR			(0x00588)
#define NSS_CC_UNIPHY_PORT3_RX_CBCR			(0x0058C)
#define NSS_CC_UNIPHY_PORT3_TX_CBCR			(0x00590)
#define NSS_CC_CE_APB_CBCR				(0x005E8)
#define NSS_CC_CE_AXI_CBCR				(0x005EC)
#define NSS_CC_NSSNOC_CE_APB_CBCR			(0x005F4)
#define NSS_CC_NSSNOC_CE_AXI_CBCR			(0x005F8)
#define NSS_CC_NSS_CSR_CBCR				(0x006B0)
#define NSS_CC_NSSNOC_NSS_CSR_CBCR			(0x006B4)

#define NSS_CC_PPE_CMD_RCGR				(0x003EC)
#define NSS_CC_PPE_CFG_RCGR				(0x003F0)
#define NSS_CC_CE_CMD_RCGR				(0x005E0)
#define NSS_CC_CE_CFG_RCGR				(0x005E4)
#define NSS_CC_CFG_CMD_RCGR				(0x006A8)
#define NSS_CC_CFG_CFG_RCGR				(0x006AC)

#define NSS_CC_PPE_SRC_SEL_CMN_PLL_NSS_CLK_375M		(6 << 8)
#define NSS_CC_PPE_SRC_SEL_GCC_GPLL0_OUT_AUX		(2 << 8)
#define NSS_CC_PORT_RX_SRC_SEL_UNIPHY_NSS_RX_CLK	(3 << 8)
#define NSS_CC_PORT_TX_SRC_SEL_UNIPHY_NSS_TX_CLK	(4 << 8)

#define CLK_1_25_MHZ					(1250000UL)
#define CLK_2_5_MHZ					(2500000UL)
#define CLK_12_5_MHZ					(12500000UL)
#define CLK_25_MHZ					(25000000UL)
#define CLK_78_125_MHZ					(78125000UL)
#define CLK_50_MHZ					(50000000UL)
#define CLK_125_MHZ					(125000000UL)
#define CLK_156_25_MHZ					(156250000UL)
#define CLK_312_5_MHZ					(312500000UL)

/*
 * QTI SPI NAND clock
 */
#define GCC_QPIC_IO_MACRO_CMD_RCGR			(0x32004)
#define GCC_QPIC_IO_MACRO_CFG_RCGR			(0x32008)
#define GCC_QPIC_IO_MACRO_CBCR				(0x3200C)
#define GCC_QPIC_AHB_CBCR				(0x32010)
#define GCC_QPIC_SLEEP_CBCR				(0x32018)
#define GCC_QPIC_CMD_RCGR				(0x32020)
#define GCC_QPIC_CFG_RCGR				(0x32024)
#define GCC_QPIC_CBCR					(0x32028)

#define IO_MACRO_CLK_400_MHZ				(400000000)
#define IO_MACRO_CLK_320_MHZ				(320000000)
#define IO_MACRO_CLK_266_MHZ				(266000000)
#define IO_MACRO_CLK_228_MHZ				(228000000)
#define IO_MACRO_CLK_200_MHZ				(200000000)
#define IO_MACRO_CLK_100_MHZ				(100000000)
#define IO_MACRO_CLK_24_MHZ				(24000000)

#define GCC_QPIC_IO_MACRO_SRC_SEL_XO_CLK		(0 << 8)
#define GCC_QPIC_IO_MACRO_SRC_SEL_GPLL0_OUT_MAIN	(1 << 8)

#endif
