// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (c) 2023, Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _IPQ5332_H_
#define _IPQ5332_H_

#include <configs/ipq5332.h>
#include <asm/u-boot.h>

typedef enum {
	SMEM_SPINLOCK_ARRAY = 7,
	SMEM_AARM_PARTITION_TABLE = 9,
	SMEM_HW_SW_BUILD_ID = 137,
	SMEM_USABLE_RAM_PARTITION_TABLE = 402,
	SMEM_POWER_ON_STATUS_INFO = 403,
	SMEM_MACHID_INFO_LOCATION = 425,
	SMEM_IMAGE_VERSION_TABLE = 469,
	SMEM_BOOT_FLASH_TYPE = 498,
	SMEM_BOOT_FLASH_INDEX = 499,
	SMEM_BOOT_FLASH_CHIP_SELECT = 500,
	SMEM_BOOT_FLASH_BLOCK_SIZE = 501,
	SMEM_BOOT_FLASH_DENSITY = 502,
	SMEM_BOOT_DUALPARTINFO = 503,
	SMEM_PARTITION_TABLE_OFFSET = 504,
	SMEM_SPI_FLASH_ADDR_LEN = 505,
	SMEM_FIRST_VALID_TYPE = SMEM_SPINLOCK_ARRAY,
	SMEM_LAST_VALID_TYPE = SMEM_SPI_FLASH_ADDR_LEN,
	SMEM_MAX_SIZE = SMEM_SPI_FLASH_ADDR_LEN + 1,
} smem_mem_type_t;

/* MACH IDs for various RDPs */
#define MACH_TYPE_IPQ5332_RDP468		0x8060000
#define MACH_TYPE_IPQ5332_RDP441		0x8060001
#define MACH_TYPE_IPQ5332_RDP441_QCA81XX	0x8060301
#define MACH_TYPE_IPQ5332_RDP441_QCA81XX_I2C	0x8060401
#define MACH_TYPE_IPQ5332_RDP442		0x8060002
#define MACH_TYPE_IPQ5332_RDP446		0x8060004
#define MACH_TYPE_IPQ5332_RDP474		0x8060006
#define MACH_TYPE_IPQ5332_RDP472		0x8060101
#define MACH_TYPE_IPQ5332_RDP473		0x8060008
#define MACH_TYPE_IPQ5332_RDP477		0x8060102
#define MACH_TYPE_IPQ5332_RDP477_256M		0x8060602
#define MACH_TYPE_IPQ5332_RDP478		0x8060007
#define MACH_TYPE_IPQ5332_RDP478_256M		0x8060207
#define MACH_TYPE_IPQ5332_RDP479		0x8060202
#define MACH_TYPE_IPQ5332_RDP480		0x8060402
#define MACH_TYPE_IPQ5332_RDP481		0x8060302
#define MACH_TYPE_IPQ5332_RDP483		0x8060107
#define MACH_TYPE_IPQ5332_RDP484		0x8060201
#define MACH_TYPE_IPQ5332_RDP486		0x8060502
#define MACH_TYPE_IPQ5332_DB_MI01_1		0x1060001
#define MACH_TYPE_IPQ5332_DB_MI02_1		0x1060003
#define MACH_TYPE_IPQ5332_DB_MI03_1		0x1060002
#define MACH_TYPE_IPQ5332_TB_MI03_1		0x1060102
#define MACH_TYPE_IPQ5332_TB_MI05_1		0x1060007

/* Crashdump Magic registers & values */
#define TCSR_BOOT_MISC_REG			((u32*)0x193D100)

#define DLOAD_MAGIC_COOKIE			0x10
#define DLOAD_DISABLED				0x40
#define DLOAD_ENABLE				BIT(4)
#define DLOAD_DISABLE				(~BIT(4))
#define CRASHDUMP_RESET				BIT(11)
#define MARK_UBOOT_MILESTONE			BIT(8)
#define BOOTCONFIG_HEALTH_MASK			BIT(13)
#define BOOTCONFIG1_HEALTH_MASK			BIT(14)

/* Crashdump minimal configs */
#define CFG_CPU_CONTEXT_DUMP_SIZE		0x1000
#define TME_CTXT_SIZE				(300 * 1024)
#define TLV_BUF_OFFSET				(500 * 1024) - TME_CTXT_SIZE
#define CFG_TLV_DUMP_SIZE			(12 * 1024)

/* DT Fixup nodes */
#define LINUX_5_4_NAND_DTS_NODE		"/soc/nand@79b0000/"
#define LINUX_5_4_MMC_DTS_NODE		"/soc/sdhci@7804000/"
#define LINUX_5_4_USB_DTS_NODE		"/soc/usb3@8A00000/dwc3@8A00000/"
#define LINUX_5_4_USB_DR_MODE_FIXUP	"/soc/usb3@8A00000/dwc3@8A00000%dr_mode%?peripheral"
#define LINUX_5_4_USB_MAX_SPEED_FIXUP	"/soc/usb3@8A00000/dwc3@8A00000%maximum-speed%?high-speed"

#define LINUX_6_x_NAND_DTS_NODE		"/soc@0/nand@79b0000/"
#define LINUX_6_x_MMC_DTS_NODE		"/soc@0/mmc@7804000/"
#define LINUX_6_x_USB_DTS_NODE		"/soc@0/usb3@8a00000/dwc3@8a00000/"
#define LINUX_6_x_USB_DR_MODE_FIXUP	"/soc@0/usb3@8a00000/dwc3@8a00000%dr_mode%?peripheral"
#define LINUX_6_x_USB_MAX_SPEED_FIXUP	"/soc@0/usb3@8a00000/dwc3@8a00000%maximum-speed%?high-speed"
#define LINUX_6_x_ROOTFS_AUTH_DTS_NODE	"/soc@0/qfprom"
#define LINUX_6_x_ROOTFS_AUTH_FIXUP	"/soc@0/qfprom/%rootfs_auth_enable%1"

#define LINUX_RSVD_MEM_DTS_NODE		"/reserved-memory/"
#define STATUS_OK			"status%?okay"
#define STATUS_DISABLED			"status%?disabled"

/*
 * TCSR Registers
 */
#define TCSR_TZ_WONCE0				0x193D000
#define TCSR_TZ_WONCE1				0x193D004

/*
 * OTP Register
 */
#define PHYA0_RFA_RFA_RFA_OTP_OTP_XO_0		0xC5D44AC
#define PHYA0_RFA_RFA_RFA_OTP_OTP_OV_1		0xC5D4484
#define QFPROM_RAW_FEATURE_CONFIG_ROW0_LSB	0xA0018

/*
 * Rootfs authentication fuse
 */
#define ROOTFS_AUTH_FUSE	0xA6044

/*
 * TME DUMP
 */

#define	TME_LOG_DUMP_FEATURE_ID			0x7
#define	TME_LOG_DUMP_FEATURE_VERSION		0x401000

struct fuse_payload {
	u32 fuse_addr;
	u32 lsb_val;
	u32 msb_val;
};

#define TME_OEM_ATE_FUSE_START			0x000A00D0
#define TME_OEM_ATE_FUSE_CNT			0x1
#define TME_OEM_ATE_FUSE_READ_SIZE		0x8

#define TME_OEM_MRC_HASH_FUSE_START		0x000A00E8
#define TME_OEM_MRC_HASH_FUSE_CNT		0x7
#define TME_OEM_MRC_HASH_FUSE_READ_SIZE		0x8

#define TME_AUTH_EN_MASK			0x41
#define TME_OEM_ID_MSK				0xFFFF0000
#define TME_PRODUCT_ID_MSK			0x0000FFFF
#endif /* _IPQ5332_H_ */
