// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (c) 2023, Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _IPQ9574_H_
#define _IPQ9574_H_

#include <configs/ipq9574.h>
#include <asm/u-boot.h>

typedef enum {
	SMEM_SPINLOCK_ARRAY = 7,
	SMEM_AARM_PARTITION_TABLE = 9,
	SMEM_HW_SW_BUILD_ID = 137,
	SMEM_USABLE_RAM_PARTITION_TABLE = 402,
	SMEM_POWER_ON_STATUS_INFO = 403,
	SMEM_MACHID_INFO_LOCATION = 425,
	SMEM_IMAGE_VERSION_TABLE = 469,
	SMEM_BOOT_FLASH_TYPE = 498,
	SMEM_BOOT_FLASH_INDEX = 499,
	SMEM_BOOT_FLASH_CHIP_SELECT = 500,
	SMEM_BOOT_FLASH_BLOCK_SIZE = 501,
	SMEM_BOOT_FLASH_DENSITY = 502,
	SMEM_BOOT_DUALPARTINFO = 503,
	SMEM_PARTITION_TABLE_OFFSET = 504,
	SMEM_SPI_FLASH_ADDR_LEN = 505,
	SMEM_FIRST_VALID_TYPE = SMEM_SPINLOCK_ARRAY,
	SMEM_LAST_VALID_TYPE = SMEM_SPI_FLASH_ADDR_LEN,
	SMEM_MAX_SIZE = SMEM_SPI_FLASH_ADDR_LEN + 1,
} smem_mem_type_t;

/* MACH IDs for various RDPs */
#define MACH_TYPE_IPQ9574_RDP417		0x8050000
#define MACH_TYPE_IPQ9574_RDP418		0x8050001
#define MACH_TYPE_IPQ9574_RDP418_EMMC		0x8050101
#define MACH_TYPE_IPQ9574_RDP437		0x8050201
#define MACH_TYPE_IPQ9574_RDP433		0x8050301
#define MACH_TYPE_IPQ9574_RDP449		0x8050501
#define MACH_TYPE_IPQ9574_RDP433_MHT_PHY	0x8050601
#define MACH_TYPE_IPQ9574_RDP453		0x8050701
#define MACH_TYPE_IPQ9574_RDP454		0x8050801
#define MACH_TYPE_IPQ9574_RDP433_MHT_SWT	0x8050901
#define MACH_TYPE_IPQ9574_RDP467		0x8051301
#define MACH_TYPE_IPQ9574_RDP455_C11		0x8050A01
#define MACH_TYPE_IPQ9574_RDP455_C12		0x8050B01
#define MACH_TYPE_IPQ9574_RDP459		0x8050C01
#define MACH_TYPE_IPQ9574_RDP457		0x8050E01
#define MACH_TYPE_IPQ9574_RDP456		0x8050F01
#define MACH_TYPE_IPQ9574_RDP458		0x8050102
#define MACH_TYPE_IPQ9574_RDP469		0x8051001
#define MACH_TYPE_IPQ9574_RDP461		0x8051201
#define MACH_TYPE_IPQ9574_RDP475		0x8050003
#define MACH_TYPE_IPQ9574_RDP475_QCA81XX	0x8050103
#define MACH_TYPE_IPQ9574_RDP475_QCA81XX_I2C	0x8050203
#define MACH_TYPE_IPQ9574_RDP476		0x8050004
#define MACH_TYPE_IPQ9574_DB_AL01_C1		0x1050000
#define MACH_TYPE_IPQ9574_DB_AL01_C2		0x1050100
#define MACH_TYPE_IPQ9574_DB_AL01_C3		0x1050200
#define MACH_TYPE_IPQ9574_DB_AL02_C1		0x1050001
#define MACH_TYPE_IPQ9574_DB_AL02_C2		0x1050101
#define MACH_TYPE_IPQ9574_DB_AL02_C3		0x1050201
#define MACH_TYPE_IPQ9574_RDP433_SFP		0x8051101

/* Crashdump Magic registers & values */
#define TCSR_BOOT_MISC_REG			((u32*)0x193D100)

#define DLOAD_MAGIC_COOKIE			0x10
#define DLOAD_DISABLED				0x40
#define DLOAD_ENABLE				BIT(4)
#define DLOAD_DISABLE				(~BIT(4))
#define CRASHDUMP_RESET				BIT(11)
#define MARK_UBOOT_MILESTONE			BIT(8)
#define BOOTCONFIG_HEALTH_MASK			BIT(13)
#define BOOTCONFIG1_HEALTH_MASK			BIT(14)


/* Crashdump minimal configs */
#define CFG_CPU_CONTEXT_DUMP_SIZE		0x1000
#define TME_CTXT_SIZE				(300 * 1024)
#define TLV_BUF_OFFSET				(500 * 1024) - TME_CTXT_SIZE
#define CFG_TLV_DUMP_SIZE			(12 * 1024)

/* DT Fixup nodes */
#define LINUX_5_4_NAND_DTS_NODE			"/soc/nand@79b0000/"
#define LINUX_5_4_MMC_DTS_NODE			"/soc/sdhci@7804000/"
#define LINUX_5_4_USB_DTS_NODE			"/soc/usb3@8A00000/dwc3@8A00000/"
#define LINUX_5_4_USB_DR_MODE_FIXUP		"/soc/usb3@8A00000/dwc3@8A00000%dr_mode%?peripheral"
#define LINUX_5_4_USB_MAX_SPEED_FIXUP		"/soc/usb3@8A00000/dwc3@8A00000%maximum-speed%?high-speed"
#define LINUX_5_4_CRYPTO_BAM_NODE		"/soc/dma@704000"
#define LINUX_5_4_CRYPTO_BAM_PIPE_TRUST_FIXUP	"/soc/dma@704000%qti,config-pipe-trust-reg%2"
#define LINUX_5_4_CRYPTO_BAM_CTRL_REMOTE_FIXUP	"/soc/dma@704000%qcom,controlled-remotely%0"

#define LINUX_6_x_NAND_DTS_NODE			"/soc@0/nand@79b0000/"
#define LINUX_6_x_MMC_DTS_NODE			"/soc@0/mmc@7804000/"
#define LINUX_6_x_SERIAL2_DTS_NODE		"/soc@0/serial@78b2000/"
#define LINUX_6_x_USB_DTS_NODE			"/soc@0/usb3@8a00000/usb@8a00000/"
#define LINUX_6_x_USB_DR_MODE_FIXUP		"/soc@0/usb3@8a00000/usb@8a00000%dr_mode%?peripheral"
#define LINUX_6_x_USB_MAX_SPEED_FIXUP		"/soc@0/usb3@8a00000/usb@8a00000%maximum-speed%?high-speed"
#define LINUX_6_x_CRYPTO_BAM_NODE		"/soc@0/dma@704000"
#define LINUX_6_x_CRYPTO_BAM_PIPE_TRUST_FIXUP	"/soc@0/dma@704000/%qti,config-pipe-trust-reg%2"
#define LINUX_6_x_CRYPTO_BAM_CTRL_REMOTE_FIXUP	"/soc@0/dma@704000%delete%qcom,controlled-remotely"
#define LINUX_6_x_ROOTFS_AUTH_DTS_NODE		"/soc@0/qfprom"
#define LINUX_6_x_ROOTFS_AUTH_FIXUP		"/soc@0/qfprom/%rootfs_auth_enable%1"


#define LINUX_RSVD_MEM_DTS_NODE		"/reserved-memory/"
#define STATUS_OK			"status%?okay"
#define STATUS_DISABLED			"status%?disabled"

/*
 * Rootfs authentication fuse
 */
#define ROOTFS_AUTH_FUSE	0xA6044

struct fuse_payload {
	u32 fuse_addr;
	u32 val;
};

#define TME_OEM_ATE_FUSE_START			0x000A00C0
#define TME_OEM_ATE_FUSE_CNT			0x2
#define TME_OEM_ATE_FUSE_READ_SIZE		0x4

#define TME_OEM_MRC_HASH_FUSE_START		0x000A00D8
#define TME_OEM_MRC_HASH_FUSE_CNT		0xE
#define TME_OEM_MRC_HASH_FUSE_READ_SIZE		0x4

#define TME_AUTH_EN_MASK			0x80
#define TME_OEM_ID_MSK				0xFFFF0000
#define TME_PRODUCT_ID_MSK			0x0000FFFF
#endif /* _IPQ9574_H_ */
