#if defined(CONFIG_NECPF)
/*
 * NECPF
 */
#define CONFIG_NECPF_GPIO_INIT
#define CONFIG_BOARD_EARLY_INIT_R
#undef CONFIG_IPADDR
#define CONFIG_IPADDR 192.168.0.1
#define CONFIG_NECPF_BOOTPW_PROMPT "Password:"
#define CONFIG_SYS_LONGHELP

/* rf_cal command */
#define CONFIG_NECPF_CMD_RF_CAL
#define CONFIG_NECPF_RF_NUM 3

#if defined(CONFIG_NECPF_WATCHDOG) || defined(CONFIG_NECPF_TP_RESET_WDT)
#define CONFIG_HW_WATCHDOG
#endif	/* CONFIG_NECPF_WATCHDOG || CONFIG_NECPF_TP_RESET_WDT */

/* MDC/MDIO端子のdrive strength変更 */
#define CONFIG_NECPF_MDIO_DRVSTR

/* D-Cache OFF */
#define CONFIG_NECPF_DCACHE_OFF

/* DL 工事コマンド */
#define CONFIG_NECPF_IMG_WRITE_NET_TIMEOUT 30
#define CONFIG_NECPF_STARTUP_ETHERLOG_OFF

#undef CONFIG_SYS_PROMPT
#define CONFIG_SYS_PROMPT "boot> "

/* BUG#34842 [ROATRY] boot consoleでCR+LFの改行に対応していない */
#define CONFIG_NECPF_SUPPORT_CRLF

/* BUG#34844 [ROTARY] boot consoleでコマンドヒストリ機能がない */
#define CONFIG_CMDLINE_EDITING

/* BUG#35780 [ROTARY] netconsoleにおいてtftpが非常に遅い */
/* #define CONFIG_NECPF_TXBUF 32 */
#define CONFIG_NECPF_TXBUF 128  /* 暫定 */
/* #define CONFIG_NECPF_RXBUF 32 */
/* #undef CONFIG_SYS_RX_ETH_BUFFER */
/* #define CONFIG_SYS_RX_ETH_BUFFER (CONFIG_NECPF_RXBUF) */

/* BUG#36384 [ROTARY] netconsole で errorlog read が正しく表示されない */
#define CONFIG_NECPF_SOU_DELAY 8
#define CONFIG_NECPF_SOU_DELAY_PACKETS 10

/* FLASHMNG */
#define CONFIG_NECPF_FLASH_BLOCK_SIZE	(64 * 1024)
#define CONFIG_NECPF_EMMC_BLOCK_SIZE	512
#define CONFIG_NECPF_FLASHMNG_FLCACHE	/* flash read cache 機能 */

/* APPSBLENV 2面化 */
#define CONFIG_NECPF_DUAL_APPSBLENV
#ifdef CONFIG_NECPF_DUAL_APPSBLENV
#ifndef __ASSEMBLY__
#include <compiler.h>
extern loff_t board_env_back_offset;
extern loff_t board_env_back_size;
#endif

#define CONFIG_ENV_SIZE_REDUND		CONFIG_ENV_SIZE
#define CONFIG_ENV_OFFSET_REDUND	board_env_back_offset
#endif	/* CONFIG_NECPF_DUAL_APPSBLENV */

/* facotry data */
#define CONFIG_NECPF_FACTORY_DATA

/* Kernel Crashlog */
#define CONFIG_NECPF_CMD_K_ERRORLOG

/* kernel read error handling */
#define CONFIG_NECPF_ERR_HANDLING

/* pkg_info */
#define CONFIG_NECPF_CMD_PKGINFO

/* Magic Number of Version data */
#define CONFIG_VER_MAGIC 0x31403910

/* arp時間短縮 (loopback試験対応) */
#define CONFIG_ARP_TIMEOUT 1000
#define CONFIG_NECPF_ARP_TIMEOUT_COUNT 5

/* BUG#49195 [ACE] bootのMACアドレス設定が不正 */
#define CONFIG_NECPF_ETHADDR_ENV "eth1addr"

/* BUG#50186 [ACE] Ether PHY 用クロック偏差 +0ppm 設定 */
#define CONFIG_NECPF_PHY_CLOCK_DEVIATION

/* MALIBU の PHY ADDRESS の OFFSET を変更 */
#define CONFIG_NECPF_CHG_PHYADDR_OFFSET

/* secure-boot 対応 */
#define CONFIG_NECPF_SECURE_BOOT_HK
#define CONFIG_NECPF_OTP_CRC	0xa870b199
#define CONFIG_NECPF_OTP_LEN	0x1c8

/* BUG#48715 eMMC erase timeout */
#define CONFIG_NECPF_ERASE_TIMEOUT	60000

/* SDHCI command timeout値を変更する */
#define CONFIG_NECPF_SDHCI_CMD_TIMEOUT

/* BUG#49094 eMMC BKOPS enable */
#define CONFIG_NECPF_BKOPS_EN
#define EXT_CSD_BKOPS_SUPPORT		502
#define EXT_CSD_BKOPS_EN		163
#define BKOPS_SUPPORTED 		(1 << 0)
#define BKOPS_ENABLE			(1 << 0)

/* Console 入出力停止 */
#define CONFIG_NECPF_KERNEL_CONSOLE_OFF
#if defined(CONFIG_NECPF_KERNEL_CONSOLE_OFF)
#define CONFIG_NECPF_CONSOLE_GPIO 66
#define CONFIG_NECPF_CONSOLE_EN_VAL 0x1
#endif	/* CONFIG_NECPF_KERNEL_CONSOLE_OFF */

/* boot password 認証(secure) */
#define CONFIG_NECPF_BOOTPW_SECURE
#if defined(CONFIG_NECPF_BOOTPW_SECURE)
#define CONFIG_NECPF_BOOTPW_SECURE_MAXRETRY	5
#define CONFIG_NECPF_FAILURE_DELAY		2500 /* wait millisecond before re-login */
#endif	/* CONFIG_NECPF_BOOTPW_SECURE */

/* BUG#59213 起動要因判定 */
#define CONFIG_NECPF_IPQ6018_RESET_REASON

#define CONFIG_LAN_LPBK_DEFAULT_PORT "lan4"

/* BUG#68163 ボタン押下による tp コマンド無効化機能 */
#define CONFIG_BTN_DISABLE

#endif	/* CONFIG_NECPF */
