#if defined(CONFIG_NECPF)
/*
 * NECPF
 */
#define CONFIG_NECPF_GPIO_INIT
#define CONFIG_BOARD_EARLY_INIT_R
#undef CONFIG_IPADDR
#define CONFIG_IPADDR 192.168.0.1
/* #define CONFIG_NECPF_LANIF "eth0" */
#define CONFIG_NECPF_SOU_LINK_WAIT 3000
#define CONFIG_NECPF_BOOTPW_PROMPT "Password:"
#define CONFIG_SYS_LONGHELP

#if defined(CONFIG_NECPF_WATCHDOG) || defined(CONFIG_NECPF_TP_RESET_WDT)
#define CONFIG_HW_WATCHDOG
#endif	/* CONFIG_NECPF_WATCHDOG || CONFIG_NECPF_TP_RESET_WDT */

#if defined(CONFIG_CMD_PMIC) && defined(CONFIG_PMIC_PM8916)
#define CONFIG_NECPF_PMIC_DEFAULT "pm8916@0"
#endif	/* CONFIG_CMD_PMIC && CONFIG_PMIC_PM8916 */

#if defined(CONFIG_NECPF_TP_USB)
#define CONFIG_NECPF_XHCI_USB20_TEST
#define CONFIG_NECPF_USB_FS_WA
#define CONFIG_NECPF_USB_SSHUB_WA
#undef CONFIG_USB_STORAGE
#endif	/* CONFIG_NECPF_TP_USB */

#if defined(CONFIG_NECPF_SLABSLIC)
#define CONFIG_NECPF_SPI_BLSP2
#define CONFIG_NECPF_SPI_SLIC_MODE
#define CONFIG_NECPF_SLIC_MAX_CH 1
#undef CONFIG_NECPF_RING_HW_TIMER
#endif	/* CONFIG_NECPF_SLABSLIC */

#if defined(CONFIG_NECPF_PCM)
#define CONFIG_NECPF_PCM_MAX_CH 1
#define CONFIG_NECPF_PCM_XFER_SAMPLES 80 /* 10ms */
#endif	/* CONFIG_NECPF_PCM */

#if defined(CONFIG_NECPF_SLAC)
#define CONFIG_NECPF_SLAC_MAX_CH 1
#endif	/* CONFIG_NECPF_SLAC */

/* BUG#34842 [ROATRY] boot consoleでCR+LFの改行に対応していない */
#define CONFIG_NECPF_SUPPORT_CRLF

/* BUG#34844 [ROTARY] boot consoleでコマンドヒストリ機能がない */
#define CONFIG_CMDLINE_EDITING

/* BUG#35780 [ROTARY] netconsoleにおいてtftpが非常に遅い */
/* #define CONFIG_NECPF_TXBUF 32 */
#define CONFIG_NECPF_TXBUF 128	/* 暫定 */
/* #define CONFIG_NECPF_RXBUF 32 */
/* #undef CONFIG_SYS_RX_ETH_BUFFER */
/* #define CONFIG_SYS_RX_ETH_BUFFER (CONFIG_NECPF_RXBUF) */

/* BUG#36384 [ROTARY] netconsole で errorlog read が正しく表示されない */
#define CONFIG_NECPF_SOU_DELAY 8
#define CONFIG_NECPF_SOU_DELAY_PACKETS 10

/* FLASHMNG */
#define CONFIG_NECPF_FLASH_BLOCK_SIZE	(64 * 1024)
#define CONFIG_NECPF_EMMC_BLOCK_SIZE	512
#define CONFIG_NECPF_FLASHMNG_FLCACHE	/* flash read cache 機能 */

/* APPSBLENV 2面化 */
#define CONFIG_NECPF_DUAL_APPSBLENV
#ifdef CONFIG_NECPF_DUAL_APPSBLENV
#ifndef __ASSEMBLY__
#include <compiler.h>
extern loff_t board_env_back_offset;
extern loff_t board_env_back_size;
#endif

#define CONFIG_ENV_SIZE_REDUND		CONFIG_ENV_SIZE
#define CONFIG_ENV_OFFSET_REDUND	board_env_back_offset
#endif	/* CONFIG_NECPF_DUAL_APPSBLENV */

/* facotry data */
#define CONFIG_NECPF_FACTORY_DATA

/* Kernel Crashlog */
#define CONFIG_NECPF_CMD_K_ERRORLOG

/* BUG#48715 eMMC erase timeout */
#define CONFIG_NECPF_ERASE_TIMEOUT	60000

/* kernel read error handling */
#define CONFIG_NECPF_ERR_HANDLING

/* pkg_info */
#define CONFIG_NECPF_CMD_PKGINFO

/* Magic Number of Version data */
#define CONFIG_VER_MAGIC 0x31403910

/* BUG#49033 [ACE] HW_ES2 Malibu LED 設定変更 */
#define CONFIG_NECPF_MALIBU_LED

/* arp時間短縮 (loopback試験対応) */
#define CONFIG_ARP_TIMEOUT 1000
#define CONFIG_NECPF_ARP_TIMEOUT_COUNT 5

/* BUG#49094 eMMC BKOPS enable */
#define CONFIG_NECPF_BKOPS_EN
#define EXT_CSD_BKOPS_SUPPORT		502
#define EXT_CSD_BKOPS_EN		163
#define BKOPS_SUPPORTED 		(1 << 0)
#define BKOPS_ENABLE			(1 << 0)

/* BUG#49195 [ACE] bootのMACアドレス設定が不正 */
#define CONFIG_NECPF_ETHADDR_ENV "eth1addr"

/* BUG#49226 [ACE] system起動しない可能性がある (bootのbuild warning) */
#if defined(CONFIG_QCA_APPSBL_DLOAD)
#define CONFIG_NECPF_APPSBL_DLOAD_WA
#endif	/* CONFIG_QCA_APPSBL_DLOAD */

/* rf-regdmn */
#define CONFIG_NECPF_CMD_RF_REGDMN

/* MDC/MDIO端子のdrive strength変更 */
#define CONFIG_NECPF_MDIO_DRVSTR

/* BUG#50186 [ACE] Ether PHY 用クロック偏差 +0ppm 設定 */
#define CONFIG_NECPF_PHY_CLOCK_DEVIATION

/* SDHCI command timeout値を変更する */
#define CONFIG_NECPF_SDHCI_CMD_TIMEOUT

/* 10G port 切替機能 */
#define CONFIG_NECPF_PORT_CHANGE

/* D-Cache OFF */
#define CONFIG_NECPF_DCACHE_OFF

/* DL 工事コマンド */
#define CONFIG_NECPF_IMG_WRITE_NET_TIMEOUT 30
#define CONFIG_NECPF_STARTUP_ETHERLOG_OFF

#endif	/* CONFIG_NECPF */
