#include "dramc_common.h"
#include "emi_fake_engine.h"

#define HAL_REG_32(reg)         (*((volatile U32 *)((u64) reg)))

#define FE_WRITE_DISABLE  1
#define FE_READ_DISABLE  0

#define FE_DEBUG_LOG_PRINT print

#define FE_ERROR_LOG_PRINT  print

#ifndef dbg_print
#define dbg_print  print
#endif

struct emi_fake_engine emi_fake_engine_global;

void HAL_REG_32_write(unsigned int value, unsigned int addr)
{
    HAL_REG_32(addr) = value;
    dsb();
}

unsigned int HAL_REG_32_read(unsigned int addr)
{
    return (HAL_REG_32(addr));
}

void FE_Set_EMI_Golden_Setting(void)
{
    HAL_REG_32_write(0x00FF0008, 0x10219400);
    //Reg_Sync_Writel(0x1021d400, 0x00FF0008);
    HAL_REG_32_write(0x00600000, 0x10219068);
    //Reg_Sync_Writel(0x1021d068, 0x00600000);
    HAL_REG_32_write(0x38460016, 0x10235050);
    //Reg_Sync_Writel(0x10245050, 0x38460016);
    HAL_REG_32_write(0x38460016, 0x10255050);
    //Reg_Sync_Writel(0x10265050, 0x38460016);
    HAL_REG_32_write(0x00FF0000, 0x10219400);
    //Reg_Sync_Writel(0x1021d400, 0x00FF0000);

    FE_ERROR_LOG_PRINT("%s: before 0x1023160C [0x%x]! \n", __func__, HAL_REG_32_read(0x1023160C));
    HAL_REG_32_write(0x4, 0x1023160C);
    FE_ERROR_LOG_PRINT("%s: after 0x1023160C [0x%x]! \n", __func__, HAL_REG_32_read(0x1023160C));
}

int emi_fake_engine_pre_init(void)
{
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    if(p_emi_fake_engine->FE_pre_init_done_flag) {
        FE_ERROR_LOG_PRINT("%s: fake engine had pre_init done! \n", __func__);
        return 0;
    }

    //FE_Set_EMI_Golden_Setting();
    HAL_REG_32_write(0x00CA00CA, 0x102302F0);//why:

    p_emi_fake_engine->eng0_addr = EMI_FAKE_ENGINE0_BASE;
    p_emi_fake_engine->eng1_addr = EMI_FAKE_ENGINE1_BASE;
    p_emi_fake_engine->infracfg_addr = INFRACFG_AO_BASE;
	p_emi_fake_engine->infracfg_mem_addr = INFRACFG_AO_MEM_BASE;
	p_emi_fake_engine->emi_addr = EMI_APB_BASE;
    p_emi_fake_engine->ddrphy_ao_cha_addr = 0x1023a000;
	p_emi_fake_engine->ddrphy_ao_chb_addr = 0x1024a000;
	p_emi_fake_engine->dramc_nao_cha_addr = 0x10238000;
	p_emi_fake_engine->dramc_nao_chb_addr = 0x10248000;

	FE_DEBUG_LOG_PRINT("%s eng0_add:0x%lx eng1_addr:0x%lx infracfg_addr:0x%lx infracfg_mem_addr:0x%lx emi_addr:0x%lx \n",
		__func__,
		(unsigned long)p_emi_fake_engine->eng0_addr,
		(unsigned long)p_emi_fake_engine->eng1_addr,
		(unsigned long)p_emi_fake_engine->infracfg_addr,
		(unsigned long)p_emi_fake_engine->infracfg_mem_addr,
		(unsigned long)p_emi_fake_engine->emi_addr);

    // Set EMI outstanding capability to 15/30
	HAL_REG_32_write(0xcfcfcfcf, p_emi_fake_engine->emi_addr + EMI_IOCL_OFF);
	HAL_REG_32_write(0x77777777, p_emi_fake_engine->emi_addr + EMI_IOCL_2ND_OFF);
	HAL_REG_32_write(0xcfcfcfcf, p_emi_fake_engine->emi_addr + EMI_IOCM_OFF);
	HAL_REG_32_write(0x77777777, p_emi_fake_engine->emi_addr + EMI_IOCM_2ND_OFF);

    p_emi_fake_engine->FE_pre_init_done_flag = 1;
    FE_DEBUG_LOG_PRINT("%s: fake engine pre_init done! \n", __func__);

    return 0;
}
unsigned int wr_dis = FE_WRITE_DISABLE;
unsigned int rd_dis = FE_READ_DISABLE;

int emi_fake_engine_init(eEMI_FE_info *p_fe)
{
	unsigned int wr_amount = 0x1f;
	unsigned int rd_amount = 0x1f;
	unsigned int data_cmp_en = 0;
    unsigned int cross_rank_en = 0;
	unsigned int loop_en = 0;
	unsigned int grp_aomunt = 15;
	unsigned int burst_len = 7;
	unsigned int bust_size = 0x4;
	unsigned int addr_offset = 0;
    unsigned int addr_offset_grp = 0;
	unsigned int pat_mode = 0x4;
	unsigned int slow_down = 0;
	unsigned int slow_down_grp = 0;
    unsigned int chn_number = 0;
    unsigned int init_pattern0 = 0x00000000;
    unsigned int init_pattern1 = 0x00000000;
    unsigned int init_pattern2 = 0x00000000;
    unsigned int init_pattern3 = 0x00000000;
    unsigned int init_pattern4 = 0xFFFFFFFF;
    unsigned int init_pattern5 = 0xFFFFFFFF;
    unsigned int init_pattern6 = 0xFFFFFFFF;
    unsigned int init_pattern7 = 0xFFFFFFFF;

    unsigned int FE_base_addr = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    if(!p_emi_fake_engine->FE_pre_init_done_flag) {
        FE_ERROR_LOG_PRINT("%s: fake engine had not do pre_init! \n", __func__);
        return -1;
    }

    if(p_fe == NULL) {
        FE_ERROR_LOG_PRINT("%s: p_fe = NULL ! \n", __func__);
        return -1;
    }

    if (p_fe->init_done_flag) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d had init done! \n", __func__, p_fe->FE_ID);
        return -1;
    }

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

    HAL_REG_32_write(1, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_RST_OFF);   //reset fake engine0
    mdelay(20);
    HAL_REG_32_write(0, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_RST_OFF);   //set fake engine0 reset bit to 0 after reset
    mdelay(20);
    HAL_REG_32_write(0, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_EN_OFF);    //set fake engine0 enable bit to 0

    HAL_REG_32_write((pat_mode << 13) | (data_cmp_en << 4)| (cross_rank_en << 3) | (loop_en << 2) | (wr_dis << 1) | rd_dis, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF);
    if(rd_dis) {
        HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) | (0x1<<0)), (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));
    } else {
        HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) & (~(0x1<<0))), (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));
    }

    if(wr_dis) {
        HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) | (0x1<<1)), (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));
    } else {
        HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) & (~(0x1<<1))), (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));
    }
    HAL_REG_32_write((slow_down_grp << 20) | (slow_down << 10) | (wr_amount << 5) | rd_amount, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF);
    HAL_REG_32_write((bust_size << 4) | burst_len, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON2_OFF);
    HAL_REG_32_write(grp_aomunt, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON3_OFF);
    HAL_REG_32_write((addr_offset_grp << 18) | (addr_offset << 8 ), FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_ADDR_OFF);
    HAL_REG_32_write((0x0 << 24) | (0x0 << 20) | (0x1 << 16) | (0x2 << 12) | (0x1 << 8) | (chn_number << 4) | (0x0), FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_HASH_OFF);

    HAL_REG_32_write(init_pattern0, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT0_OFF);
    HAL_REG_32_write(init_pattern1, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT1_OFF);
    HAL_REG_32_write(init_pattern2, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT2_OFF);
    HAL_REG_32_write(init_pattern3, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT3_OFF);
    HAL_REG_32_write(init_pattern4, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT4_OFF);
    HAL_REG_32_write(init_pattern5, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT5_OFF);
    HAL_REG_32_write(init_pattern6, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT6_OFF);
    HAL_REG_32_write(init_pattern7, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_INIT_PAT7_OFF);

    HAL_REG_32_write((p_fe->wr_addr), (FE_base_addr+EMI_FAKE_ENG_FAKE_ENG_START_ADDR_OFF));
    FE_DEBUG_LOG_PRINT("%s: fake engine %d, wr_addr [0x%x] & rd_addr [0x%x]\n", __func__, (unsigned int)p_fe->FE_ID, p_fe->wr_addr, p_fe->rd_addr);

    p_fe->init_done_flag = 1;
    FE_DEBUG_LOG_PRINT("%s: fake engine %d init done! \n", __func__, p_fe->FE_ID);

    return 0;
}


int start_emi_fake_engine(eEMI_FE_info *p_fe)
{
    unsigned int FE_base_addr = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    if(p_fe == NULL) {
        FE_ERROR_LOG_PRINT("%s: p_fe = NULL ! \n", __func__);
        return -1;
    }

    if (!p_fe->init_done_flag) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d had not init done! \n", __func__, p_fe->FE_ID);
        return -1;
    }

    if (p_fe->status == eFE_RUNNING) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d running, please wait \n", __func__, (unsigned int)p_fe->FE_ID);
        return -1;
    }

    FE_DEBUG_LOG_PRINT("%s: start fake engine %d \n", __func__, (unsigned int)p_fe->FE_ID);

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

#if 0
    infra_emi_dcm_cfg0 = HAL_REG_32_read(p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
    infra_emi_dcm_cfg0 |= (0x1 << 18);
    HAL_REG_32_write(infra_emi_dcm_cfg0, p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
    infra_emi_dcm_cfg0 &= ~(0x1 << 2);
    HAL_REG_32_write(infra_emi_dcm_cfg0, p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
#endif

    HAL_REG_32_write(1, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_EN_OFF);   //start fake engine0
    mdelay(20);

    if(0 == HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_IDLE_OFF)) {
        p_fe->status = eFE_RUNNING;
    } else {
        FE_ERROR_LOG_PRINT("%s: fake engine %d idle, ERROR\n", __func__, (unsigned int)p_fe->FE_ID);
        return -1;
    }

    return 0;
}

void emi_fake_engine_loop_mode_enable(eEMI_FE_info *p_fe)
{
    unsigned int FE_base_addr = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

    HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) | (0x1<<2)), (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));//enable loop mode
    mdelay(10);
    if(0 == FE_READ_DISABLE) {
        HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) & (~(0x1<<0))), (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));//enable read
    }
}

void emi_fake_engine_loop_mode_disable(eEMI_FE_info *p_fe)
{
    unsigned int FE_base_addr = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

    if(0 == FE_READ_DISABLE) {
        HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) | (0x1<<0)), (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));//disable read
    }
    mdelay(10);
    HAL_REG_32_write((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF) & (~(0x1<<2))) , (FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON0_OFF));//disable loop_mode
}

void emi_fake_engine_check_done(eEMI_FE_info *p_fe)
{
    unsigned int FE_base_addr = 0;
    unsigned int timeout_cnt = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

    while(!(HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_DONE_OFF))) {//polling check
        FE_ERROR_LOG_PRINT("%s: polling check ! \n", __func__);
        mdelay(1);//fanning
        timeout_cnt++;
        if(timeout_cnt>10) {
            FE_ERROR_LOG_PRINT("%s: polling check fail! \n", __func__);
            break;
        }
        if(FE_WRITE_DISABLE) {
            break;
        }
    }
    mdelay(1);//must add delay 1s as DE request fanning
    FE_DEBUG_LOG_PRINT("%s: polling check done, FE Done! \n", __func__);
}

int set_emi_fake_engine_slow(eEMI_FE_info *p_fe, unsigned int slow_down,unsigned slow_down_grp)
{
    unsigned int tmp_CR_value = 0;
    unsigned int FE_base_addr = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    FE_DEBUG_LOG_PRINT("%s: slow_down[%d], slow_down_grp[%d]! \n", __func__, slow_down, slow_down_grp);

    if(p_fe == NULL) {
        FE_ERROR_LOG_PRINT("%s: p_fe = NULL ! \n", __func__);
        return -1;
    }

    if (!p_fe->init_done_flag) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d had not init done! \n", __func__, p_fe->FE_ID);
        return -1;
    }

    if (p_fe->status == eFE_RUNNING) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d running, please stop first \n", __func__, (unsigned int)p_fe->FE_ID);
        return -1;
    }

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

    tmp_CR_value = HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF);
    tmp_CR_value &= (~0x3ff00000);
    tmp_CR_value &= (~0x000ffc00);
    HAL_REG_32_write(tmp_CR_value | (slow_down_grp << 20) | (slow_down << 10), FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF);
    //HAL_REG_32_write(grp_amount, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON3_OFF);
    mdelay(20);

    return 0;
}

int start_emi_fake_engine_slow_down(eEMI_FE_info *p_fe, unsigned int slow_down,unsigned slow_down_grp)
{
    unsigned int FE_base_addr = 0;
    unsigned int tmp_CR_value = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    FE_DEBUG_LOG_PRINT("%s: slow_down[%d], slow_down_grp[%d]! \n", __func__, slow_down, slow_down_grp);

    if(p_fe == NULL) {
        FE_ERROR_LOG_PRINT("%s: p_fe = NULL ! \n", __func__);
        return -1;
    }

    if (!p_fe->init_done_flag) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d had not init done! \n", __func__, p_fe->FE_ID);
        return -1;
    }

    if (p_fe->status == eFE_RUNNING) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d running, please wait \n", __func__, (unsigned int)p_fe->FE_ID);
        return -1;
    }

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

    tmp_CR_value = HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF);
    tmp_CR_value &= (~0x3ff00000);
    tmp_CR_value &= (~0x000ffc00);
    HAL_REG_32_write(tmp_CR_value | (slow_down_grp << 20) | (slow_down << 10), FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF);
    HAL_REG_32_write((p_fe->wr_addr), FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_START_ADDR_OFF);
    FE_DEBUG_LOG_PRINT("%s: fake engine %d, CR[0x%x], slow [%d] & slow_grp [%d]\n", __func__, (unsigned int)p_fe->FE_ID,
        (HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF)),
        (((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF))&0x000ffc00)>>10),
        (((HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_CON1_OFF))&0x3ff00000)>>20));

    FE_DEBUG_LOG_PRINT("%s: fake engine %d, wr_addr [0x%x] & rd_addr [0x%x]\n", __func__, (unsigned int)p_fe->FE_ID, p_fe->wr_addr, p_fe->rd_addr);

#if 0
    infra_emi_dcm_cfg0 = HAL_REG_32_read(p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
    infra_emi_dcm_cfg0 |= (0x1 << 18);
    HAL_REG_32_write(infra_emi_dcm_cfg0, p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);

    infra_emi_dcm_cfg0 &= ~(0x1 << 2);
    HAL_REG_32_write(infra_emi_dcm_cfg0, p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
#endif

    HAL_REG_32_write(1, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_EN_OFF);   //start fake engine0
    mdelay(20);

    if(0 == HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_IDLE_OFF)) {
        p_fe->status = eFE_RUNNING;
    } else {
        FE_ERROR_LOG_PRINT("%s: fake engine %d idle, ERROR\n", __func__, (unsigned int)p_fe->FE_ID);
        return -1;
    }

    return 0;
}

int stop_emi_fake_engine(eEMI_FE_info *p_fe)
{
    unsigned int FE_base_addr = 0;
    struct emi_fake_engine *p_emi_fake_engine = &emi_fake_engine_global;

    if(p_fe == NULL) {
        FE_ERROR_LOG_PRINT("%s: p_fe = NULL ! \n", __func__);
        return -1;
    }

    if (p_fe->status == eFE_IDLE) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d idle! \n", __func__, (unsigned int)p_fe->FE_ID);
        return -1;
    }
    FE_DEBUG_LOG_PRINT("%s: stop fake engine %d \n", __func__, (unsigned int)p_fe->FE_ID);

    if(p_fe->FE_ID == EMI_FAKE_ENGINE_0) {
        FE_base_addr = p_emi_fake_engine->eng0_addr;
    } else {
        FE_base_addr = p_emi_fake_engine->eng1_addr;
    }

    #if 0
    infra_emi_dcm_cfg0 = HAL_REG_32_read(p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
	infra_emi_dcm_cfg0 &= ~(0x1 << 18);
	HAL_REG_32_write(infra_emi_dcm_cfg0, p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
	infra_emi_dcm_cfg0 |= (0x1<< 2);
	HAL_REG_32_write(infra_emi_dcm_cfg0, p_emi_fake_engine->infracfg_mem_addr + INFRA_EMI_DCM_CFG0_OFF);
    #endif

	HAL_REG_32_write(0, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_EN_OFF);   //start fake engine0
	mdelay(20);
	HAL_REG_32_write(1, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_RST_OFF);   //reset fake engine0
	mdelay(20);
	HAL_REG_32_write(0, FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_RST_OFF);   //set reset fake engine0 bit to 0 after reset
	mdelay(20);

    if(0 == HAL_REG_32_read(FE_base_addr + EMI_FAKE_ENG_FAKE_ENG_IDLE_OFF)) {
        FE_ERROR_LOG_PRINT("%s: fake engine %d busy, ERROR\n", __func__, (unsigned int)p_fe->FE_ID);
        return -1;
    } else {
        p_fe->status = eFE_IDLE;
    }

    p_fe->init_done_flag = 0;

    return 0;
}

eEMI_FE_info fe_0;
eEMI_FE_info fe_1;
void emi_fake_engine_traffic_infinite_start(eFAKE_ENGINE_ID FE_ID, unsigned int test_address, unsigned int slow_val)
{
    eEMI_FE_info *p_fe = NULL;
    FE_ERROR_LOG_PRINT("%s: FE%d start, test address = 0x%x\n", __func__, FE_ID, test_address);

    if(FE_ID == EMI_FAKE_ENGINE_0) {
        p_fe = &fe_0;
    } else {
        p_fe = &fe_1;
    }

    p_fe->FE_ID = FE_ID;
    p_fe->init_done_flag = 0;
    p_fe->status = eFE_IDLE;
    p_fe->wr_addr = test_address;
    p_fe->rd_addr = test_address;

    emi_fake_engine_pre_init();

    emi_fake_engine_init(p_fe);
    set_emi_fake_engine_slow(p_fe, slow_val, slow_val);
    emi_fake_engine_loop_mode_enable(p_fe);

    start_emi_fake_engine(p_fe);
    mdelay(10);
}

void emi_fake_engine_traffic_infinite_stop(eFAKE_ENGINE_ID FE_ID)
{
    eEMI_FE_info *p_fe = NULL;
    if(FE_ID == EMI_FAKE_ENGINE_0) {
        p_fe = &fe_0;
    } else {
        p_fe = &fe_1;
    }

    if(p_fe->status == eFE_IDLE) {
        FE_ERROR_LOG_PRINT("%s: stop Fail, FE%d IDLE \n", __func__, p_fe->FE_ID);
        return;
    }

    FE_ERROR_LOG_PRINT("%s: stop FE%d \n", __func__, p_fe->FE_ID);
    emi_fake_engine_loop_mode_disable(p_fe);
    emi_fake_engine_check_done(p_fe);
    stop_emi_fake_engine(p_fe);
    mdelay(10);
}

void emi_fake_engine_both_traffic_infinite_start(unsigned int FE0_test_address, unsigned int FE1_test_address, unsigned int slow_val)
{
    emi_fake_engine_traffic_infinite_start(EMI_FAKE_ENGINE_0, FE0_test_address, slow_val);
    emi_fake_engine_traffic_infinite_start(EMI_FAKE_ENGINE_1, FE1_test_address, slow_val);
}

void emi_fake_engine_both_traffic_infinite_stop(void)
{
    emi_fake_engine_traffic_infinite_stop(EMI_FAKE_ENGINE_0);
    emi_fake_engine_traffic_infinite_stop(EMI_FAKE_ENGINE_1);
}
typedef enum
{
    BWL_PORT_AP0,
	BWL_PORT_AP1,
    BWL_PORT_MM1,
    BWL_PORT_CONNSYS,
    BWL_PORT_NETSYS,
    BWL_PORT_MM0,
    BWL_PORT_NONE,
    BWL_PORT_PERI,
} BWL_PORT;

#define         EMI_DBWA                ((P_U32)(EMI_APB_BASE+0xF00))
#define         EMI_DBWA_2ND            ((P_U32)(EMI_APB_BASE + 0xF2C))

void bw_monitor_config(BWL_PORT port)
{
    unsigned int tmp = 0;
    unsigned int tmp_select_port = 0;

    //DRV_WriteReg32(EMI_BMEN, 0x00FF0000);

    DRV_WriteReg32(EMI_DBWA, 0x0);
    DRV_WriteReg32(EMI_DBWA_2ND, 0x0);

    tmp = DRV_Reg32(EMI_DBWA);
    if ((port == BWL_PORT_MM1) || (port == BWL_PORT_MM0))
    {
        tmp_select_port = ((0x1<<BWL_PORT_MM1)<<8) | ((0x1<<BWL_PORT_MM0)<<8);
    } else {
        tmp_select_port = ((0x1<<port)<<8);
    }


    tmp = tmp   | tmp_select_port      //select port ID
                | (0x1<<4)      //disable boundary limitation, monitor all type
                | (0x0<<3)      //disable ID selection, monitor all transaction ID type
                | (0x1<<2)      //monitor normal priority
                | (0x1<<1)      //write cmd
                | (0x1<<0);     //read cmd
    DRV_WriteReg32(EMI_DBWA, tmp);

    tmp = DRV_Reg32(EMI_DBWA_2ND);
    tmp = tmp   | ((u32)0xF<<28)     //monitor high priority
                | (0x0<<16)     //byte low boundary, select all bytes
                | (0xF<<12)     //select all channel,all rank
                | (0x1FF<<0);   //byte up boundary, select all bytes
    DRV_WriteReg32(EMI_DBWA_2ND, tmp);

    //disable DCM -> 0x10205060[31:24] = 0xff;
    DRV_WriteReg32(EMI_CONM, (DRV_Reg32(EMI_CONM) | ((u32)0xff << 24)));
    DRV_WriteReg32(EMI_CONN, (DRV_Reg32(EMI_CONN) | ((u32)0xff << 24)));

    DRV_WriteReg32(EMI_BMEN, (DRV_Reg32(EMI_BMEN) | (0x1 << 3)));
    //dbg_print("bw_monitor_config: EMI_BMEN [0x%x] EMI_DBWA[0x%x] EMI_DBWA_2ND[0x%x]\n", DRV_Reg32(EMI_BMEN), DRV_Reg32(EMI_DBWA), DRV_Reg32(EMI_DBWA_2ND));
}


unsigned int bm_emi_wact = 0, bm_emi_bact = 0, bm_emi_wsct = 0, bm_emi_bcnt = 0;

void bw_monitor_stop_FE(unsigned int slow_val, unsigned int slow_grp)
{
    volatile unsigned int  latency_cnt = 0;
    /* Disable CG */
    WRITE_REG(READ_REG(EMI_CONM) | (0x1 << 30), EMI_CONM);
    WRITE_REG(READ_REG(DDRPHY_REG_MISC_CG_CTRL0) | (0x1 << 9), DDRPHY_REG_MISC_CG_CTRL0);
    //WRITE_REG(READ_REG(DDRPHY_CH1_MISC_CG_CTRL0) | (0x1 << 9), DDRPHY_CH1_MISC_CG_CTRL0);

    /*pause*/
    DRV_WriteReg32(EMI_BMEN, DRV_Reg32(EMI_BMEN)|(0x1<<1));

    bm_emi_wact = DRV_Reg32(EMI_WACT);
    bm_emi_bact = DRV_Reg32(EMI_BACT);
    bm_emi_wsct = DRV_Reg32(EMI_WSCT);
    bm_emi_bcnt = DRV_Reg32(EMI_BCNT);

    if((bm_emi_wact >= 0xFFFFFFFF)||(bm_emi_wsct >= 0xFFFFFFFF)||(bm_emi_bact >= 0xFFFFFFFF)||(bm_emi_bcnt >= 0xFFFFFFFF)) {
        dbg_print("overrun, bm_emi_wact[%d], bm_emi_wsct[%d], bm_emi_bact[%d], bm_emi_bcnt[%d]\n", bm_emi_wact, bm_emi_wsct, bm_emi_bact, bm_emi_bcnt);
    }

    //LP4 ==> ratio = (emi_wact * 8(Bytes)) / (cycle_cnt * (8 / ddr)) / (ddr * 2(Bytes) * U1ChannelNum)
    //LP3 ==> ratio = (emi_wact * 8(Bytes)) / (cycle_cnt * (4 / ddr)) / (ddr * 4(Bytes) * U1ChannelNum)
    //DDR4 ==> ratio = (emi_wact * 8(Bytes)) / (cycle_cnt * (8 / ddr)) / (ddr * 2(Bytes) * U1ChannelNum)

    unsigned char u1ChannelNum = 1;
    unsigned int emi_feq = 400; // 1600 1:8 3200
    unsigned int ratio = 0;
    unsigned int ratio_wsct = 0;
    unsigned int bw = 0;

    bw = (bm_emi_wact*8)/(bm_emi_bcnt/emi_feq);
    ratio = bm_emi_wact/(bm_emi_bcnt/(1000/2/u1ChannelNum)); // 1/1000, not %
    ratio_wsct = bm_emi_wsct/(bm_emi_bcnt/(1000/2/u1ChannelNum)); // 1/1000, not %

    //dbg_print("bm_emi_wact[%d], bm_emi_wsct[%d], bm_emi_bact[%d], bm_emi_bcnt[%d]\n", bm_emi_wact, bm_emi_wsct, bm_emi_bact, bm_emi_bcnt);
    //dbg_print("slow[%d, %d], emi_feq = %d, ratio = %d, ratio_wsct = %d, bw = %d MB/s\n", slow, slow_grp, emi_feq, ratio, ratio_wsct, bw);
    dbg_print("slow %d, slow_grp %d, bm_emi_wact \033[1;36m%d\033[m bm_emi_bcnt \033[1;36m%d\033[m ratio \033[1;36m%d.%d\033[m ratio_wsct \033[1;36m%d.%d\033[m bw \033[1;36m%d\033[mMB latency_cnt \033[1;36m%d\033[m\n",
               slow_val,    slow_grp,    bm_emi_wact,                   bm_emi_bcnt,                   ratio/10,         ratio%10, ratio_wsct/10,   ratio_wsct%10,  bw,                     latency_cnt);
    /* Enable CG */
	
	WRITE_REG(READ_REG(EMI_CONM) & ~(0x1 << 30), EMI_CONM);
	WRITE_REG(READ_REG(DDRPHY_REG_MISC_CG_CTRL0) & ~(0x1 << 9), DDRPHY_REG_MISC_CG_CTRL0);
	//WRITE_REG(READ_REG(DDRPHY_CH1_MISC_CG_CTRL0) & ~(0x1 << 9), DDRPHY_CH1_MISC_CG_CTRL0);
}

#define MEM_TEST_START  0x40000000

void bw_monitor_start(void)
{
    /* Disable CG */
    DRV_WriteReg32(EMI_CONM, (DRV_Reg32(EMI_CONM) | ((u32)0xff << 24)));//no dcm
    DRV_WriteReg32(EMI_CONN, (DRV_Reg32(EMI_CONN) | ((u32)0xff << 24)));//no dcm
    WRITE_REG(READ_REG(DDRPHY_REG_MISC_CG_CTRL0) | (0x1 << 9), DDRPHY_REG_MISC_CG_CTRL0);
    //WRITE_REG(READ_REG(DDRPHY_CH1_MISC_CG_CTRL0) | (0x1 << 9), DDRPHY_CH1_MISC_CG_CTRL0);

    DRV_WriteReg32(EMI_CONH, (DRV_Reg32(EMI_CONH) & (~(0x3))));//no dcm
    DRV_WriteReg32(EMI_CONH_2ND, (DRV_Reg32(EMI_CONH_2ND) & (~(0x7))));//no dcm

    /*clear bus monitor cnt*/
    DRV_WriteReg32(EMI_BMEN, (DRV_Reg32(EMI_BMEN) | (0x1 << 3)));//disable emi idle
    DRV_WriteReg32(EMI_BMEN, (DRV_Reg32(EMI_BMEN) & (0xFFFFFFFC)));

#if 0
    bm_emi_wact = DRV_Reg32(EMI_WACT);
    bm_emi_bact = DRV_Reg32(EMI_BACT);
    bm_emi_wsct = DRV_Reg32(EMI_WSCT);
    bm_emi_bcnt = DRV_Reg32(EMI_BCNT);
    dbg_print("after clear: bm_emi_wact[%d], bm_emi_wsct[%d], bm_emi_bact[%d], bm_emi_bcnt[%d]\n", bm_emi_wact, bm_emi_wsct, bm_emi_bact, bm_emi_bcnt);
#endif
    DRV_WriteReg32(EMI_BMEN, (DRV_Reg32(EMI_BMEN) | 0x00FF0000));// select all port for BACT.
    DRV_WriteReg32(EMI_BMEN, (DRV_Reg32(EMI_BMEN) | 0x1));//enable monitor start

    /* Enable CG */
	WRITE_REG(READ_REG(EMI_CONM) & ~((u32)0xFF << 24), EMI_CONM);
    WRITE_REG(READ_REG(EMI_CONN) & ~((u32)0xFF << 24), EMI_CONN);
	WRITE_REG(READ_REG(DDRPHY_REG_MISC_CG_CTRL0) & ~(0x1 << 9), DDRPHY_REG_MISC_CG_CTRL0);
	//WRITE_REG(READ_REG(DDRPHY_CH1_MISC_CG_CTRL0) & ~(0x1 << 9), DDRPHY_CH1_MISC_CG_CTRL0);
}

#define MEM_TEST_START  0x40000000
void fe_test(void)
{
	fe_0.FE_ID = EMI_FAKE_ENGINE_0;
	fe_0.wr_addr= MEM_TEST_START;
	fe_0.rd_addr= MEM_TEST_START;
	fe_0.init_done_flag= 0;
	fe_0.status= eFE_IDLE;

	fe_1.FE_ID = EMI_FAKE_ENGINE_1;
	fe_1.wr_addr= MEM_TEST_START;
	fe_1.rd_addr= MEM_TEST_START;
	fe_1.init_done_flag= 0;
	fe_1.status= eFE_IDLE;

	unsigned int i;
	unsigned int slow[] = {0, 0, 0, 19, 23, 29, 39, 47, 59, 79, 119, 239, 297, 397, 596, 1023};
	//DDR3
	//unsigned int slow[] = {0, 0, 0, 19, 23, 29, 39, 47, 59, 79, 119, 239, 297, 397, 596, 1023};
	//DDR4

	unsigned int cnt;
	for(cnt=0;cnt<3;cnt++) {
		if(cnt == 0){
			wr_dis = 0;
			rd_dis = 1;
		}
		if(cnt == 1){
			wr_dis = 1;
			rd_dis = 0;
		}
		if(cnt == 2){
			wr_dis = 0;
			rd_dis = 0;
		}
		dbg_print("FE test cnt %d \n", cnt);
		for(i=0;i<(sizeof(slow)/sizeof(unsigned int));i++) {
	//	for(i=0;i<1024;i++) {
			dbg_print("FE test slow %d \n", slow[i]);
	//		dbg_print("FE test slow %d \n", i);
			emi_fake_engine_traffic_infinite_start(EMI_FAKE_ENGINE_0, MEM_TEST_START, slow[i]);
			//emi_fake_engine_both_traffic_infinite_start(MEM_TEST_START, MEM_TEST_START, slow[i]);
			mcDELAY_MS(10);
			//mcDELAY_MS(1000);
			bw_monitor_config(BWL_PORT_MM0);
			bw_monitor_config(BWL_PORT_MM1);
			bw_monitor_start();
			mcDELAY_MS(5000);
			bw_monitor_stop_FE(slow[i], slow[i]);
			emi_fake_engine_traffic_infinite_stop(EMI_FAKE_ENGINE_0);
			//emi_fake_engine_both_traffic_infinite_stop();
		}
	}

}

