/*----------------------------------------------------------------------------*
 * Copyright Statement:                                                       *
 *                                                                            *
 *   This software/firmware and related documentation ("MediaTek Software")   *
 * are protected under international and related jurisdictions'copyright laws *
 * as unpublished works. The information contained herein is confidential and *
 * proprietary to MediaTek Inc. Without the prior written permission of       *
 * MediaTek Inc., any reproduction, modification, use or disclosure of        *
 * MediaTek Software, and information contained herein, in whole or in part,  *
 * shall be strictly prohibited.                                              *
 * MediaTek Inc. Copyright (C) 2010. All rights reserved.                     *
 *                                                                            *
 *   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND     *
 * AGREES TO THE FOLLOWING:                                                   *
 *                                                                            *
 *   1)Any and all intellectual property rights (including without            *
 * limitation, patent, copyright, and trade secrets) in and to this           *
 * Software/firmware and related documentation ("MediaTek Software") shall    *
 * remain the exclusive property of MediaTek Inc. Any and all intellectual    *
 * property rights (including without limitation, patent, copyright, and      *
 * trade secrets) in and to any modifications and derivatives to MediaTek     *
 * Software, whoever made, shall also remain the exclusive property of        *
 * MediaTek Inc.  Nothing herein shall be construed as any transfer of any    *
 * title to any intellectual property right in MediaTek Software to Receiver. *
 *                                                                            *
 *   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its *
 * representatives is provided to Receiver on an "AS IS" basis only.          *
 * MediaTek Inc. expressly disclaims all warranties, expressed or implied,    *
 * including but not limited to any implied warranties of merchantability,    *
 * non-infringement and fitness for a particular purpose and any warranties   *
 * arising out of course of performance, course of dealing or usage of trade. *
 * MediaTek Inc. does not provide any warranty whatsoever with respect to the *
 * software of any third party which may be used by, incorporated in, or      *
 * supplied with the MediaTek Software, and Receiver agrees to look only to   *
 * such third parties for any warranty claim relating thereto.  Receiver      *
 * expressly acknowledges that it is Receiver's sole responsibility to obtain *
 * from any third party all proper licenses contained in or delivered with    *
 * MediaTek Software.  MediaTek is not responsible for any MediaTek Software  *
 * releases made to Receiver's specifications or to conform to a particular   *
 * standard or open forum.                                                    *
 *                                                                            *
 *   3)Receiver further acknowledge that Receiver may, either presently       *
 * and/or in the future, instruct MediaTek Inc. to assist it in the           *
 * development and the implementation, in accordance with Receiver's designs, *
 * of certain softwares relating to Receiver's product(s) (the "Services").   *
 * Except as may be otherwise agreed to in writing, no warranties of any      *
 * kind, whether express or implied, are given by MediaTek Inc. with respect  *
 * to the Services provided, and the Services are provided on an "AS IS"      *
 * basis. Receiver further acknowledges that the Services may contain errors  *
 * that testing is important and it is solely responsible for fully testing   *
 * the Services and/or derivatives thereof before they are used, sublicensed  *
 * or distributed. Should there be any third party action brought against     *
 * MediaTek Inc. arising out of or relating to the Services, Receiver agree   *
 * to fully indemnify and hold MediaTek Inc. harmless.  If the parties        *
 * mutually agree to enter into or continue a business relationship or other  *
 * arrangement, the terms and conditions set forth herein shall remain        *
 * effective and, unless explicitly stated otherwise, shall prevail in the    *
 * event of a conflict in the terms in any agreements entered into between    *
 * the parties.                                                               *
 *                                                                            *
 *   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and    *
 * cumulative liability with respect to MediaTek Software released hereunder  *
 * will be, at MediaTek Inc.'s sole discretion, to replace or revise the      *
 * MediaTek Software at issue.                                                *
 *                                                                            *
 *   5)The transaction contemplated hereunder shall be construed in           *
 * accordance with the laws of Singapore, excluding its conflict of laws      *
 * principles.  Any disputes, controversies or claims arising thereof and     *
 * related thereto shall be settled via arbitration in Singapore, under the   *
 * then current rules of the International Chamber of Commerce (ICC).  The    *
 * arbitration shall be conducted in English. The awards of the arbitration   *
 * shall be final and binding upon both parties and shall be entered and      *
 * enforceable in any court of competent jurisdiction.                        *
 *---------------------------------------------------------------------------*/


#include <common/debug.h>
#include <lib/mmio.h>
#include <emi.h>
#include <dramc_top.h>
#include <mtk_drm.h>
#include "emi_hw.h"

/* do not change the test size ! */
#define MEM_TEST_SIZE		0x2000
/* Memory test */
#define PATTERN1		0x5A5A5A5A
#define PATTERN2		0xA5A5A5A5
#define DRAM_TOTAL_SIZE		0x80000000
#define DRAM_BASE_VIRT		0x40000000

extern int g_ddr_reserve_enable;
extern int g_ddr_reserve_success;

void dram_clear(void)
{
	unsigned int addr;

	for (addr = 0; addr < DRAM_TOTAL_SIZE; addr = addr + 0x4)
		(*(volatile unsigned int *)(uint64_t)(DRAM_BASE_VIRT + addr)) = 0x0;
}

void cpu_mem_test_pattern_write(unsigned int base, unsigned int len)
{
	unsigned int pattern;

	for (pattern = 0; pattern < len; pattern = pattern + 0x4)
		(*(volatile unsigned int *)(uint64_t)(base + pattern)) = pattern;

}

void cpu_mem_test_pattern_check(unsigned int base, unsigned int len)
{
	unsigned int pattern, data, err = 0;

	for (pattern = 0; pattern < len; pattern = pattern + 0x4) {
		data = (*(volatile unsigned int *)(uint64_t)(base + pattern));
		if (data != pattern){
			err++;
			ERROR("dram mem test error!!! address:0x%x, exp:0x%x, act:0x%x\n", (base + pattern), pattern,data);
			ERROR("dram re-read act:0x%x\n", (*(volatile unsigned int *)(uint64_t)(base + pattern)));
		}
	}
	if (err == 0) {
		INFO("dram mem test 0x%x ~ 0x%x pass\n",base, base+len);
	}
	else {
		INFO("dram mem test 0x%x ~ 0x%x fail, fail : %d\n", base, base+len, err);
	}
}

int complex_mem_test(unsigned long start, unsigned long len)
{
	unsigned char *mem8_base = (unsigned char *)start;
	unsigned short *mem16_base = (unsigned short *)start;
	unsigned int *mem32_base = (unsigned int *)start;
	unsigned int *mem_base = (unsigned int *)start;
	unsigned char pattern8;
	unsigned short pattern16;
	unsigned long i;
	unsigned int j, size, value, pattern32;

	size = len >> 2;

	/* Verify the tied bits (tied high) */
	for (i = 0; i < size; i++)
		mem32_base[i] = 0;

	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0)
			return -1;
		else
			mem32_base[i] = 0xffffffff;

	/* Verify the tied bits (tied low) */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0xffffffff)
			return -2;
		else
			mem32_base[i] = 0x00;

	/* Verify pattern 1 (0x00~0xff) */
	for (pattern8 = 0, i = 0; i < len; i++)
		mem8_base[i] = pattern8++;

	for (pattern8 = 0, i = 0; i < len; i++)
		if (mem8_base[i] != pattern8++)
			return -3;

	/* Verify pattern 2 (0x00~0xff) */
	for (pattern8 = 0, i = j = 0; i < len; i += 2, j++) {
		if (mem8_base[i] == pattern8)
			mem16_base[j] = pattern8;
		if (mem16_base[j] != pattern8)
			return -4;

		pattern8 += 2;
	}

	/* Verify pattern 3 (0x00~0xffff) */
	for (pattern16 = 0, i = 0; i < (len >> 1); i++)
		mem16_base[i] = pattern16++;

	for (pattern16 = 0, i = 0; i < (len >> 1); i++)
		if (mem16_base[i] != pattern16++)
			return -5;

	/* Verify pattern 4 (0x00~0xffffffff) */
	for (pattern32 = 0, i = 0; i < (len >> 2); i++)
		mem32_base[i] = pattern32++;

	for (pattern32 = 0, i = 0; i < (len >> 2); i++)
		if (mem32_base[i] != pattern32++)
			return -6;

	/* Pattern 5: Filling memory range with 0x44332211 */
	for (i = 0; i < size; i++)
		mem32_base[i] = 0x44332211;

	/* Read Check then Fill Memory with a5a5a5a5 Pattern */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0x44332211)
			return -7;
		else
			mem32_base[i] = 0xa5a5a5a5;

	/* Read Check then Fill Memory with 00 Byte Pattern at offset 0h */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0xa5a5a5a5)
			return -8;
		else
			mem8_base[i * 4] = 0x00;

	/* Read Check then Fill Memory with 00 Byte Pattern at offset 2h */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0xa5a5a500)
			return -9;
		else
			mem8_base[i * 4 + 2] = 0x00;

	/* Read Check then Fill Memory with 00 Byte Pattern at offset 1h */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0xa500a500)
			return -10;
		else
			mem8_base[i * 4 + 1] = 0x00;

	/* Read Check then Fill Memory with 00 Byte Pattern at offset 3h */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0xa5000000)
			return -11;
		else
			mem8_base[i * 4 + 3] = 0x00;

	/* Read Check then Fill Memory with ffff Word Pattern at offset 1h */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0x00000000)
			return -12;
		else
			mem16_base[i * 2 + 1] = 0xffff;

	/* Read Check then Fill Memory with ffff Word Pattern at offset 0h */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0xffff0000)
			return -13;
		else
			mem16_base[i * 2] = 0xffff;

	/* Read Check */
	for (i = 0; i < size; i++)
		if (mem32_base[i] != 0xffffffff)
			return -14;

	/** Additional verification **/

	/* stage 1 => write 0 */
	for (i = 0; i < size; i++)
		mem_base[i] = PATTERN1;

	/* stage 2 => read 0, write 0xF */
	for (i = 0; i < size; i++) {
		value = mem_base[i];
		if (value != PATTERN1)
			return -15;

		mem_base[i] = PATTERN2;
	}

	/* stage 3 => read 0xF, write 0 */
	for (i = 0; i < size; i++) {
		value = mem_base[i];
		if (value != PATTERN2)
			return -16;

		mem_base[i] = PATTERN1;
	}

	/* stage 4 => read 0, write 0xF */
	for (i = 0; i < size; i++) {
		value = mem_base[i];
		if (value != PATTERN1)
			return -17;

		mem_base[i] = PATTERN2;
	}

	/* stage 5 => read 0xF, write 0 */
	for (i = 0; i < size; i++) {
		value = mem_base[i];
		if (value != PATTERN2)
			return -18;

		mem_base[i] = PATTERN1;
	}

	/* stage 6 => read 0 */
	for (i = 0; i < size; i++) {
		value = mem_base[i];
		if (value != PATTERN1)
			return -19;
	}

	/* 1/2/4-byte combination test */
	i = (unsigned long)mem_base;

	while (i < (unsigned long)mem_base + (size << 2)) {
		*((unsigned char *)i) = 0x78;
		i += 1;
		*((unsigned char *)i) = 0x56;
		i += 1;
		*((unsigned short *)i) = 0x1234;
		i += 2;
		*((unsigned int *)i) = 0x12345678;
		i += 4;
		*((unsigned short *)i) = 0x5678;
		i += 2;
		*((unsigned char *)i) = 0x34;
		i += 1;
		*((unsigned char *)i) = 0x12;
		i += 1;
		*((unsigned int *)i) = 0x12345678;
		i += 4;
		*((unsigned char *)i) = 0x78;
		i += 1;
		*((unsigned char *)i) = 0x56;
		i += 1;
		*((unsigned short *)i) = 0x1234;
		i += 2;
		*((unsigned int *)i) = 0x12345678;
		i += 4;
		*((unsigned short *)i) = 0x5678;
		i += 2;
		*((unsigned char *)i) = 0x34;
		i += 1;
		*((unsigned char *)i) = 0x12;
		i += 1;
		*((unsigned int *)i) = 0x12345678;
		i += 4;
	}

	for (i = 0; i < size; i++) {
		value = mem_base[i];
		if (value != 0x12345678)
			return -20;
	}

	/* Verify pattern 1 (0x00~0xff) */
	mem8_base[0] = pattern8;
	mtk_mem_dbg_print("Verify pattern 1 (0x00~0xff)...\n");
	mtk_mem_dbg_print("EMI: mem8_base[0] = pattern8 = 0x%x\n", pattern8);
	pattern8 = 0;
	for (i = 0, i = 0; i < size * 4; i++) {
		unsigned char waddr8 = i + 1, raddr8 = i;

		if (i < size * 4 - 1)
			mem8_base[waddr8] = pattern8 + 1;
		if (mem8_base[raddr8] != pattern8) {
			ERROR("EMI: TEST FAIL @ mem8_base[%ld]:\nunexpect value %x <--> %x\n", i, mem8_base[raddr8], pattern8);
			break;
			return -21;
		}
		pattern8++;
	}

	/* Verify pattern 2 (0x00~0xffff) */
	mtk_mem_dbg_print("Verify pattern 2 (0x00~0xffff)...\n");
	pattern16 = 0;
	mem16_base[0] = pattern16;
	mtk_mem_dbg_print("EMI: mem16_base[0] = pattern16 = 0x%x\n", pattern16);
	for (i = 0, i = 0; i < size * 2; i++) {
		if (i < size * 2 - 1)
			mem16_base[i + 1] = pattern16 + 1;

		if (mem16_base[i] != pattern16) {
			ERROR("EMI: TEST FAIL @ mem16_base[%ld]:\nunexpect value %x <--> %x\n", i, mem16_base[i], pattern16);
			break;
			return -22;
		}

		pattern16++;
	}

	/* Verify pattern 3 (0x00~0xffffffff) */
	pattern32 = 0;
	mem32_base[0] = pattern32;
	mtk_mem_dbg_print("Verify pattern 3 (0x00~0xffffffff)...\n");
	mtk_mem_dbg_print("EMI: mem32_base[0] = pattern32 = 0x%x\n", pattern32);
	for (i = 0, i = 0; i < size; i++) {
		if (i < size - 1)
			mem32_base[i + 1] = pattern32 + 1;

		if (mem32_base[i] != pattern32) {
			ERROR("EMI: TEST FAIL @ mem32_base[%ld]:\nunexpect value %x <--> %x\n", i, mem32_base[i], pattern32);
			break;
			return -23;
		}

		pattern32++;
	}

	return 0;
}

void wdt_reset_enable()
{
	INFO("wdt_reset_enable +++\n");
	*(volatile unsigned int *)(0x1001c000 + 0x00000000) = 0x23000100;
	*(volatile unsigned int *)(0x1001c000 + 0x00000080) = 0x51000000;
	/* reset wdt */
	*(volatile unsigned int *)(0x1001c000 + 0x0000014) = 0x1209;

	INFO("wdt_reset_enable ---\n");
	while(1);
}

//#define DRM_MODE_TEST_IN_BL2
#define DRM_TEST_LEN 0x30000000		// adjust according to the actual situation 
#define DRM_TEST_OFFSET 0x8000000	// adjust according to the actual situation 

//extern void dram_lp2_fpga_MT7986_init(void);
void mtk_mem_init_real(void)
{
	int ret = 0;
#ifdef DRM_MODE_TEST_IN_BL2
	U64 count = 0;
#endif
//	int region;

	/* clear EMI MPU protect setting */
//	for (region = 0; region < 16; region++)
	{
//		DRV_WriteReg32((uint64_t)EMI_MPU_SA(region), 0x0);
//		DRV_WriteReg32((uint64_t)EMI_MPU_EA(region), 0x0);
//		DRV_WriteReg32((uint64_t)EMI_MPU_APC(region, 0), 0x0);
	}

#ifdef DDR_RESERVE_MODE
	unsigned int emi_cona;

	mtk_mem_dbg_print("\nbefore ctrl3 = 0x%x\n", mmio_read_32(0x1001c080));
	mmio_write_32(0x1001c000, 0x23000100);

	mtk_mem_dbg_print("clear request & ack\n");
	mmio_write_32(0x1001c080, 0x51000000);

	mtk_mem_dbg_print("after ctrl3 = 0x%x\n\n", mmio_read_32(0x1001c080));

	check_ddr_reserve_status();

	if((g_ddr_reserve_enable==1) && (g_ddr_reserve_success==1)) {
		/* EMI register dummy read: give clock to EMI APB register to avoid DRAM access hang */
		emi_cona = *((volatile U32 *)EMI_CONA);
		mtk_mem_dbg_print("[DDR Reserve mode] EMI dummy read CONA = 0x%x\n", emi_cona);

		/* disable transaction mask */
		*(volatile unsigned int *) (EMI_CHN0_APB_BASE + 0x3FC) &= 0xFFFFFFFE;
		//*(volatile unsigned int *) (EMI_CHN1_APB_BASE + 0x3FC) &= 0xFFFFFFFE;

		/* disable EMI APB protect */
		DRV_WriteReg32(EMI_MPU_CTRL, DRV_Reg32(EMI_MPU_CTRL)&0xFFFFFFFE);
		set_mtk_drm_to_default();
		drm_dram_reserved(0);
		#ifdef DRM_MODE_TEST_IN_BL2
		NOTICE("drm check pattern compare, just only read\n\n");
		for (count=0; count<DRM_TEST_LEN; count+=4)
		{
			if (*(volatile unsigned int *)(count + DDR_BASE + DRM_TEST_OFFSET) != count + (0x5a5a <<16))
			{
				#if 1	//def CPU_RW_TEST_FULL_SIZE
				ERROR("[Fail] Addr: %x, expect: 0x%llx, actual:0x%x\n", (unsigned int)(count + DDR_BASE + DRM_TEST_OFFSET), count + (0x5a5a <<16), *(volatile unsigned int *)(count + DDR_BASE + DRM_TEST_OFFSET));
				#endif
			}
		}
		#endif
	} else /* normal boot */
#endif
	{
		/* disable EMI APB protect */
//		INFO("EMI_MPU_CTRL=%x 1st\n",DRV_Reg32(EMI_MPU_CTRL));
//		DRV_WriteReg32(EMI_MPU_CTRL, DRV_Reg32(EMI_MPU_CTRL)&0xFFFFFFFE);
//		INFO("EMI_MPU_CTRL=%x 2nd\n",DRV_Reg32(EMI_MPU_CTRL));

		/* init debugtop DRM */
		mtk_drm_init();

		/* force clear RGU control for DRAMC before calibration */
		drm_release_rg_dramc_conf_iso();//Release DRAMC/PHY conf ISO
		drm_release_rg_dramc_iso();//Release PHY IO ISO
		drm_release_rg_dramc_sref();//Let DRAM Leave SR

		mt_set_emi();
		mtk_mem_dbg_print("EMI: complex real chip dram calibration\n");
#ifdef DDR_RESERVE_MODE
		drm_dram_reserved(0);	// if DDR_RESERVE_MODE is define, need to set '1' for your test
		#ifdef DRM_MODE_TEST_IN_BL2
		mtk_mem_dbg_print("DRM: test write start\n");
		for (count= 0; count<DRM_TEST_LEN; count+=4)
		{
			*(volatile unsigned int *)(count + DDR_BASE + DRM_TEST_OFFSET) = count + (0x5a5a <<16);
		}
		mtk_mem_dbg_print("DRM: test write end\n");
		#endif
#endif
	}

	//dram_lp2_fpga_MT7986_init();
	ret = complex_mem_test(DRAM_BASE_VIRT, MEM_TEST_SIZE);
	if (!ret) {
		NOTICE("EMI: complex R/W mem test passed\n");
	}
	else {
		ERROR("EMI: complex R/W mem test failed: %d\n", ret);
	}
	/*while(1)
	{
	cpu_mem_test_pattern_write(DRAM_BASE_VIRT,DRAM_TOTAL_SIZE);
	cpu_mem_test_pattern_check(DRAM_BASE_VIRT,DRAM_TOTAL_SIZE);
	dram_clear();
	INFO("dram_clear done\n");
	}*/
#ifdef DDR_RESERVE_MODE
	//g_ddr_reserve_ready = 0x9502;
	/* Disable DDR-reserve mode in pre-loader stage then enable it again in kernel stage */
#ifdef DRM_MODE_TEST_IN_BL2
	wdt_reset_enable();
#endif
#endif
}
