/*----------------------------------------------------------------------------*
 * Copyright Statement:                                                       *
 *                                                                            *
 *   This software/firmware and related documentation ("MediaTek Software")   *
 * are protected under international and related jurisdictions'copyright laws *
 * as unpublished works. The information contained herein is confidential and *
 * proprietary to MediaTek Inc. Without the prior written permission of       *
 * MediaTek Inc., any reproduction, modification, use or disclosure of        *
 * MediaTek Software, and information contained herein, in whole or in part,  *
 * shall be strictly prohibited.                                              *
 * MediaTek Inc. Copyright (C) 2010. All rights reserved.                     *
 *                                                                            *
 *   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND     *
 * AGREES TO THE FOLLOWING:                                                   *
 *                                                                            *
 *   1)Any and all intellectual property rights (including without            *
 * limitation, patent, copyright, and trade secrets) in and to this           *
 * Software/firmware and related documentation ("MediaTek Software") shall    *
 * remain the exclusive property of MediaTek Inc. Any and all intellectual    *
 * property rights (including without limitation, patent, copyright, and      *
 * trade secrets) in and to any modifications and derivatives to MediaTek     *
 * Software, whoever made, shall also remain the exclusive property of        *
 * MediaTek Inc.  Nothing herein shall be construed as any transfer of any    *
 * title to any intellectual property right in MediaTek Software to Receiver. *
 *                                                                            *
 *   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its *
 * representatives is provided to Receiver on an "AS IS" basis only.          *
 * MediaTek Inc. expressly disclaims all warranties, expressed or implied,    *
 * including but not limited to any implied warranties of merchantability,    *
 * non-infringement and fitness for a particular purpose and any warranties   *
 * arising out of course of performance, course of dealing or usage of trade. *
 * MediaTek Inc. does not provide any warranty whatsoever with respect to the *
 * software of any third party which may be used by, incorporated in, or      *
 * supplied with the MediaTek Software, and Receiver agrees to look only to   *
 * such third parties for any warranty claim relating thereto.  Receiver      *
 * expressly acknowledges that it is Receiver's sole responsibility to obtain *
 * from any third party all proper licenses contained in or delivered with    *
 * MediaTek Software.  MediaTek is not responsible for any MediaTek Software  *
 * releases made to Receiver's specifications or to conform to a particular   *
 * standard or open forum.                                                    *
 *                                                                            *
 *   3)Receiver further acknowledge that Receiver may, either presently       *
 * and/or in the future, instruct MediaTek Inc. to assist it in the           *
 * development and the implementation, in accordance with Receiver's designs, *
 * of certain softwares relating to Receiver's product(s) (the "Services").   *
 * Except as may be otherwise agreed to in writing, no warranties of any      *
 * kind, whether express or implied, are given by MediaTek Inc. with respect  *
 * to the Services provided, and the Services are provided on an "AS IS"      *
 * basis. Receiver further acknowledges that the Services may contain errors  *
 * that testing is important and it is solely responsible for fully testing   *
 * the Services and/or derivatives thereof before they are used, sublicensed  *
 * or distributed. Should there be any third party action brought against     *
 * MediaTek Inc. arising out of or relating to the Services, Receiver agree   *
 * to fully indemnify and hold MediaTek Inc. harmless.  If the parties        *
 * mutually agree to enter into or continue a business relationship or other  *
 * arrangement, the terms and conditions set forth herein shall remain        *
 * effective and, unless explicitly stated otherwise, shall prevail in the    *
 * event of a conflict in the terms in any agreements entered into between    *
 * the parties.                                                               *
 *                                                                            *
 *   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and    *
 * cumulative liability with respect to MediaTek Software released hereunder  *
 * will be, at MediaTek Inc.'s sole discretion, to replace or revise the      *
 * MediaTek Software at issue.                                                *
 *                                                                            *
 *   5)The transaction contemplated hereunder shall be construed in           *
 * accordance with the laws of Singapore, excluding its conflict of laws      *
 * principles.  Any disputes, controversies or claims arising thereof and     *
 * related thereto shall be settled via arbitration in Singapore, under the   *
 * then current rules of the International Chamber of Commerce (ICC).  The    *
 * arbitration shall be conducted in English. The awards of the arbitration   *
 * shall be final and binding upon both parties and shall be entered and      *
 * enforceable in any court of competent jurisdiction.                        *
 *---------------------------------------------------------------------------*/

#include "dramc_common.h"
#include "dramc_dv_init.h"
#include "dramc_int_global.h"
#include "x_hal_io.h"
#include "sv_c_data_traffic.h"
#include "dramc_pi_api.h"
#include "dramc_pi_api_pcddr.h"
#include "dramc_top.h"
#include "emi_fake_engine.h"
#if (FOR_DV_SIMULATION_USED==0) && !__ETT__
#include "emi.h"
#endif
#if (FOR_DV_SIMULATION_USED==0)
#if __ETT__ && !QT_GUI_Tool
#include <ett_common.h>
#endif
#endif


DRAMC_CTX_T dram_ctx_chb;

#if (FOR_DV_SIMULATION_USED == 1)
U8 gu1BroadcastIsLP4 = TRUE;
#endif

bool gAndroid_DVFS_en = FALSE;
bool gUpdateHighestFreq = FALSE;

#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
   SAVE_TIME_FOR_CALIBRATION_T SavetimeData;
#endif

U8 gHQA_Test_Freq_Vcore_Level = 0;  // 0: only 1 freq  , others are multi freq  1: low vcore 2: high vcore

#ifdef DDR_RESERVE_MODE
EXTERN u32 g_ddr_reserve_success;
#endif

#define ENABLE_DRAM_SINGLE_FREQ_SELECT 0xFF  // 0xFF=all freq by gFreqTbl. The 0x"X" != 0xFF for single freq by gFreqTbl index, ex: 0x3 for DDR3733

/* cc notes: since files in /common folder will use gFreqTbl & gFreqTbl_lp5,
 * these two structure cannot be removed. Reuse it for DDR4 & DDR3 with a mapping...
 * For PCDDR specific codes, can use gFreqTbl_PC3/PC4 instead...
 */
DRAM_DFS_FREQUENCY_TABLE_T gFreqTbl_PC3[DRAM_DFS_SHUFFLE_MAX] = {
    {DDR3_DDR2133 /*0*/,DIV4_MODE, SRAM_SHU0, DUTY_DEFAULT, VREF_CALI_ON, CLOSE_LOOP_MODE},  // highest freq of term group (3733) must k first.
//	{DDR3_DDR1866 /*0*/,DIV4_MODE, SRAM_SHU0, DUTY_DEFAULT, VREF_CALI_OFF, CLOSE_LOOP_MODE},  // highest freq of term group (3733) must k first.
};

DRAM_DFS_FREQUENCY_TABLE_T gFreqTbl_PC4[DRAM_DFS_SHUFFLE_MAX] = {
    {DDR4_DDR3200 /*0*/, DIV8_MODE, SRAM_SHU0, DUTY_DEFAULT, VREF_CALI_ON, CLOSE_LOOP_MODE},
//    {DDR4_DDR2667 /*0*/, DIV8_MODE, SRAM_SHU0, DUTY_DEFAULT, VREF_CALI_ON, CLOSE_LOOP_MODE},
};

DRAM_DFS_FREQUENCY_TABLE_T *gFreqTbl;
const U8 u1FreqTblCnt_PC3 = ARRAY_SIZE(gFreqTbl_PC3);
const U8 u1FreqTblCnt_PC4 = ARRAY_SIZE(gFreqTbl_PC4);

#define LJPLL_FREQ_DEBUG_LOG 0

#if RUNTIME_SHMOO_RELEATED_FUNCTION
#undef ENABLE_DRAM_SINGLE_FREQ_SELECT
#define ENABLE_DRAM_SINGLE_FREQ_SELECT 1  // Only DDR1600 and DDR4266
#endif

DRAMC_CTX_T DramContext = {
	.support_channel_num = CHANNEL_NUM,
	.channel = CHANNEL_A,
	.support_rank_num = RANK_SINGLE,
	.rank = RANK_0,

#if __FLASH_TOOL_DA__
	.freq_sel = DDR4_DDR1600,
#else
#if FOR_DV_SIMULATION_USED
#if DV_SIMULATION_PC4
	.freq_sel = DDR4_DDR1600,
#else
	.freq_sel = DDR3_DDR1333,
#endif
#else
	.freq_sel = DDR4_DDR3200,
#endif
#endif /* __FLASH_TOOL_DA__ */

	.shu_type = DRAM_DFS_SHUFFLE_1,
	.dram_type = TYPE_DDR4,
	.odt_onoff = ODT_OFF,
	.data_width = DATA_WIDTH_16BIT,
	.test2_1 = DEFAULT_TEST2_1_CAL,
	.test2_2 = DEFAULT_TEST2_2_CAL,

#if ENABLE_K_WITH_WORST_SI_UI_SHIFT
	.test_pattern = TEST_WORST_SI_PATTERN,
#else
	.test_pattern = TEST_XTALK_PATTERN,
#endif

	.vendor_id = 0x88,
	.revision_id = REVISION_ID_MAGIC,
	.density = 0x0,
	.ranksize = { 0 },

	.u2num_dlycell_perT = 0,
	.u2DelayCellTimex100 = 270,

#if PRINT_CALIBRATION_SUMMARY
	.aru4CalResultFlag = {
		{0, 0},
#if CHANNEL_NUM > 1
		{0,0},
#endif
	},
	.aru4CalExecuteFlag = {
		{0, 0},
#if CHANNEL_NUM > 1
		{0,0},
#endif
	},
	.SWImpCalResult = 0,
	.SWImpCalExecute = 0,

#if PRINT_CALIBRATION_SUMMARY_FASTK_CHECK
	.FastKResultFlag = {
		{0, 0},
#if CHANNEL_NUM > 1
		{0. 0},
#endif
	},
	.FastKExecuteFlag = {
		{0, 0},
#if CHANNEL_NUM > 1
		{0. 0},
#endif
	},
#endif /* PRINT_CALIBRATION_SUMMARY_FASTK_CHECK */
#endif /* PRINT_CALIBRATION_SUMMARY */

	#if CHANNEL_NUM==1
	.isWLevInitShift = {0x0},
	#else
	.isWLevInitShift = {0x0, 0x0},
	#endif

#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
	.femmc_Ready = FALSE,

	.Bypass_TXWINDOW = FALSE,
	.Bypass_RXWINDOW = FALSE,
	.BYPASS_RDDQC = FALSE,
	.SAVE_TIME_FOR_CALIBRATION_T = &SavetimeData,
#endif

	.pDFSTable = NULL, /* PC3/4 do NOT support DFS */
	.ShuRGAccessIdx = DRAM_DFS_REG_SHU0,

	.u1PLLMode = PHYPLL_MODE,
	.curDBIState = DBI_OFF,
	.DRAMPinmux = PINMUX_DSC,
	.u110GBEn = { 0 },
	.PhySwapRule = { PHY_SWAP_RULE_AR_BR },
};

#if defined(DDR_INIT_TIME_PROFILING) || (__ETT__ && SUPPORT_SAVE_TIME_FOR_CALIBRATION)
DRAMC_CTX_T gTimeProfilingDramCtx;
U8 gtime_profiling_flag = 0;
#endif

void vSetVcoreByFreq(DRAMC_CTX_T *p)
{
#if DRAMC_CTRL_BY_SOC
#if __FLASH_TOOL_DA__
	dramc_set_vcore_voltage(725000);
#else
	#if __ETT__ || defined(DRAM_HQA)
	unsigned int vio18 = 0;
	#endif
	unsigned int vcore, vdram, vddq, vmddr;

	vcore = vdram = vddq = vmddr = 0;

#if __ETT__
	hqa_set_voltage_by_freq(p, &vio18, &vcore, &vdram, &vddq, &vmddr);
#elif defined(VCORE_BIN)
	switch (vGet_Current_ShuLevel(p)) {
	case SRAM_SHU0:  //4266
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU0);
		if (!vcore)
	#endif
		vcore = get_vcore_uv_table(0);
		break;
	case SRAM_SHU1:   //3200
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU1);
		if (!vcore)
	#endif
		vcore = (get_vcore_uv_table(0) + get_vcore_uv_table(1)) >> 1;
		break;
	case SRAM_SHU2:  //2400
	case SRAM_SHU3:  //1866
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU2);
		if (!vcore)
	#endif
		vcore = (get_vcore_uv_table(0) + get_vcore_uv_table(2)) >> 1;
		break;
	case SRAM_SHU4:  //1600
	case SRAM_SHU5:  //1200
	case SRAM_SHU6:  //800
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU4);
		if (!vcore)
	#endif
		vcore = (get_vcore_uv_table(0) + get_vcore_uv_table(3)) >> 1;
		break;
	}
#else
	switch (vGet_Current_ShuLevel(p)) {
	case SRAM_SHU0: // 4266
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU0);
	#else
		vcore = SEL_PREFIX_VCORE(LP4, KSHU0);
	#endif
		break;
	case SRAM_SHU1: // 3200
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU1);
	#else
		vcore = SEL_PREFIX_VCORE(LP4, KSHU1);
	#endif
		break;
	case SRAM_SHU2: // 2400
	case SRAM_SHU3: //1866
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU2);
	#else
		vcore = SEL_PREFIX_VCORE(LP4, KSHU2);
	#endif
		break;
	case SRAM_SHU4: //1600
	case SRAM_SHU5: //1200
	case SRAM_SHU6: //800
	#ifdef VOLTAGE_SEL
		vcore = vcore_voltage_select(KSHU4);
	#else
		vcore = SEL_PREFIX_VCORE(LP4, KSHU4);
	#endif
		break;
	default:
		return;
    }
#endif

	if (vcore)
		dramc_set_vcore_voltage(vcore);

#if defined(DRAM_HQA)
	if (vio18)
		dramc_set_vio18_voltage(vio18);

	if (vdram)
		dramc_set_vdram_voltage(p->dram_type, vdram);

	if (vddq)
		dramc_set_vddq_voltage(p->dram_type, vddq);

	if (vmddr)
		dramc_set_vmddr_voltage(vmddr);
#endif

#ifdef FOR_HQA_REPORT_USED
    switch (vGet_Current_ShuLevel(p)) {
        case SRAM_SHU0: //3733
        case SRAM_SHU1: //3200
	case SRAM_SHU2: //2400
	case SRAM_SHU3: //1866
	case SRAM_SHU4: //1600
	case SRAM_SHU5: //1200
	case SRAM_SHU6: //800
		gHQA_Test_Freq_Vcore_Level = 0; //only 1 freq
            break;
        default:
            mcSHOW_DBG_MSG("[HQA] undefined shuffle level for Vcore (SHU%d)\r\n", vGet_Current_ShuLevel(p));
#if __ETT__
            while(1);
#endif
            break;
    }
#endif

#ifndef DDR_INIT_TIME_PROFILING
	mcSHOW_DBG_MSG("Read voltage for %d, %d\n", p->frequency, vGet_Current_ShuLevel(p));
	mcSHOW_DBG_MSG("Vio18 = %d\n", dramc_get_vio18_voltage());
	mcSHOW_DBG_MSG("Vcore = %d\n", dramc_get_vcore_voltage());
	mcSHOW_DBG_MSG("Vdram = %d\n", dramc_get_vdram_voltage(p->dram_type));
	mcSHOW_DBG_MSG("Vddq = %d\n", dramc_get_vddq_voltage(p->dram_type));
	mcSHOW_DBG_MSG("Vmddr = %d\n", dramc_get_vmddr_voltage());
#endif
#endif
#endif
}

U32 vGetVoltage(DRAMC_CTX_T *p, U32 get_voltage_type)
{
#if (defined(DRAM_HQA) || __ETT__) && DRAMC_CTRL_BY_SOC
    if (get_voltage_type==0)
        return dramc_get_vcore_voltage();

    if (get_voltage_type==1)
        return dramc_get_vdram_voltage(p->dram_type);

    if (get_voltage_type==2)
        return dramc_get_vddq_voltage(p->dram_type);

    if (get_voltage_type==3)
           return dramc_get_vio18_voltage();
    if (get_voltage_type==4)
             return dramc_get_vmddr_voltage();

#endif

    return 0;
}

///TODO: wait for porting +++
#ifdef FIRST_BRING_UP
void Test_Broadcast_Feature(DRAMC_CTX_T *p)
{
    U32 u4RegBackupAddress[] =
    {
        (DDRPHY_REG_SHU_RK_B0_DQ0),
        (DDRPHY_REG_SHU_RK_B1_DQ0),
    };
    U32 read_value;
    U32 backup_broadcast;

    backup_broadcast = GetDramcBroadcast();

    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

    DramcBackupRegisters(p, u4RegBackupAddress, sizeof(u4RegBackupAddress) / sizeof(U32), TO_ALL_CHANNEL);

    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);

    vIO32Write4B(DDRPHY_REG_SHU_RK_B0_DQ0, 0xA55A00FF);

    read_value = u4IO32Read4B(DDRPHY_REG_SHU_RK_B1_DQ0); /* fcCheetah will be mapping to BRB1 */
    if (read_value != 0xA55A00FF)
    {
        mcSHOW_ERR_MSG("Check Erro! Broad Cast CHA RG to CHB Fail!!\n");
        while (1);
    }

    mcSHOW_DBG_MSG("%s: Pass...\n", __func__);
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

    DramcRestoreRegisters(p, u4RegBackupAddress, sizeof(u4RegBackupAddress) / sizeof(U32), TO_ALL_CHANNEL);

    DramcBroadcastOnOff(backup_broadcast);
}
#endif

#if __ETT__
void ett_set_emi_rank1_address(void)
{
    static unsigned int remap_rank1_done = 0;

    if (!remap_rank1_done)
    {
    #ifndef MT6873_FPGA
        set_emi_before_rank1_mem_test();
    #endif
        remap_rank1_done = 1;
    }
}
#endif

void mem_test_address_calculation(DRAMC_CTX_T * p, U32 uiSrcAddr, U32*pu4Dest)
{
//    U32 u4RankSize;

#if 0	//__ETT__
    *pu4Dest = uiSrcAddr - RANK0_START_VA + RANK1_START_VA;
#else
    *pu4Dest = uiSrcAddr + p->ranksize[RANK_0];
#endif
}

#if CPU_RW_TEST_AFTER_K
void vDramCPUReadWriteTestAfterCalibration(DRAMC_CTX_T *p)
{
    U8 u1DumpInfo=0, u1RankIdx;
    U32 uiLen, count, uiFixedAddr, uiRankdAddr[RANK_MAX];
    U32 pass_count, err_count = 0;
    uiLen = 0xffff;

#ifdef CPU_RW_TEST_FULL_SIZE
	//need to enable autorefresh to avoid error during big size
	vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_RK_REF_CTRL), 0, RK_REF_CTRL_REFDIS);	   //REFDIS=0, enable auto refresh

	if (p->ranksize[0] == 128)
		uiLen = 0x8000000;
	else if (p->ranksize[0] == 256)
		uiLen = 0x10000000;
	else if (p->ranksize[0] == 512)
		uiLen = 0x20000000;
	else if (p->ranksize[0] == 1024)
		uiLen = 0x40000000;
	else if (p->ranksize[0] == 2048)
		uiLen = 0x80000000;
	else {
		mcSHOW_ERR_MSG("get dram size setting abnormal!\n");
		uiLen = 0xffff;
	}

	mcSHOW_DBG_MSG("dram size: %d MB, test length: 0x%x\n", (U32)p->ranksize[0], uiLen);
#endif

	#if __ETT__ || FOR_DV_SIMULATION_USED
	U32 addr;
	#else
	U64 addr;
	#endif

#if GATING_ONLY_FOR_DEBUG
    DramcGatingDebugInit(p);
#endif

    uiRankdAddr[0] = DDR_BASE;
    mem_test_address_calculation(p, DDR_BASE, &uiRankdAddr[1]);

    for(u1RankIdx =0; u1RankIdx< p->support_rank_num; u1RankIdx++)
    {
        u1DumpInfo=0;
        err_count=0;
        pass_count=0;

        #if !__ETT__
        // scy: not to test rank1 (wrong addr 0x0000_0000)
        if (u1RankIdx >= 1)
            continue;
        #endif

        #if GATING_ONLY_FOR_DEBUG
        DramcGatingDebugRankSel(p, u1RankIdx);
        #endif

        uiFixedAddr = uiRankdAddr[u1RankIdx];

        for (count= 0; count<uiLen; count+=4)
        {
			addr = count +uiFixedAddr;
            *(volatile unsigned int *)(addr) = count + (0x5a5a <<16);
        }

        for (count=0; count<uiLen; count+=4)
        {
        	addr = count +uiFixedAddr;
            if (*(volatile unsigned int *)(addr) != count + (0x5a5a <<16))
            {
                //mcSHOW_DBG_MSG("[Fail] Addr %x = 0x%x\n", count, *(volatile unsigned int *)(uint64_t)(count));
                #ifdef CPU_RW_TEST_FULL_SIZE
				mcSHOW_ERR_MSG("[Fail] Addr: %x, expect: 0x%x, actual:0x%x\n", (unsigned int)addr, count + (0x5a5a <<16), *(volatile unsigned int *)addr);
				#endif
                err_count++;
            }
            else
                pass_count ++;
        }

#if RUNTIME_SHMOO_RELEATED_FUNCTION && SUPPORT_SAVE_TIME_FOR_CALIBRATION
        if (err_count==0)
        {
#if __ETT__
            mcSHOW_ERR_MSG("CH %c,RANK %d,BYTE %d,VRANGE %d,VREF %d,PI %d,MEM_RESULT PASS\n",
                p->pSavetimeData->Runtime_Shmoo_para.TX_Channel == 0 ? 'A' : 'B',
                p->pSavetimeData->Runtime_Shmoo_para.TX_Rank,
                p->pSavetimeData->Runtime_Shmoo_para.TX_Byte,
                p->pSavetimeData->Runtime_Shmoo_para.TX_Vref_Range,
                p->pSavetimeData->Runtime_Shmoo_para.TX_Vref_Value,
                p->pSavetimeData->Runtime_Shmoo_para.TX_PI_delay-p->pSavetimeData->Runtime_Shmoo_para.TX_Original_PI_delay);
#else
            print("CH %c,RANK %d,BYTE %d,VRANGE %d,VREF %d,PI %d,MEM_RESULT PASS\n",
                p->pSavetimeData->Runtime_Shmoo_para.TX_Channel == 0 ? 'A' : 'B',
                p->pSavetimeData->Runtime_Shmoo_para.TX_Rank,
                p->pSavetimeData->Runtime_Shmoo_para.TX_Byte,
                p->pSavetimeData->Runtime_Shmoo_para.TX_Vref_Range,
                p->pSavetimeData->Runtime_Shmoo_para.TX_Vref_Value,
                p->pSavetimeData->Runtime_Shmoo_para.TX_PI_delay-p->pSavetimeData->Runtime_Shmoo_para.TX_Original_PI_delay);
#endif
        }
#else
        if(err_count)
        {
            mcSHOW_DBG_MSG("[MEM_TEST] Rank %d Fail.", u1RankIdx);
            u1DumpInfo =1;
#if defined(SLT)
            while(1);
#endif
        }
        else
        {
            mcSHOW_DBG_MSG("[MEM_TEST] Rank %d OK.", u1RankIdx);
        }
        mcSHOW_DBG_MSG("(uiFixedAddr 0x%x, Pass count = %d, Fail count = %d)\n", uiFixedAddr, pass_count, err_count);
#endif
    }

#ifdef DDR_RESERVE_MODE
	g_ddr_reserve_success |= (err_count == 0) ? 1 : 0;
#endif

    if(u1DumpInfo)
    {
        // Read gating error flag
        #if (FOR_DV_SIMULATION_USED==0)
        DramcDumpDebugInfo(p);
        #endif
    }

    #if GATING_ONLY_FOR_DEBUG
    DramcGatingDebugExit(p);
    #endif
}
#endif


#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
#if !EMMC_READY
u32 g_dram_save_time_init_done[DRAM_DFS_SHUFFLE_MAX] = {0};
SAVE_TIME_FOR_CALIBRATION_T SaveTimeDataByShuffle[DRAM_DFS_SHUFFLE_MAX];
#endif
DRAM_STATUS_T DramcSave_Time_For_Cal_End(DRAMC_CTX_T *p)
{
    if (!u1IsLP4Family(p->dram_type))
        return DRAM_FAIL;

    if (p->femmc_Ready == 0)
    {
        #if EMMC_READY
        write_offline_dram_calibration_data(p->shu_type, p->pSavetimeData);
        mcSHOW_DBG_MSG("[FAST_K] Save calibration result to emmc\n");
        #else
        g_dram_save_time_init_done[p->shu_type] = 1;
        memcpy(&(SaveTimeDataByShuffle[p->shu_type]), p->pSavetimeData, sizeof(SAVE_TIME_FOR_CALIBRATION_T));
        mcSHOW_DBG_MSG("[FAST_K] Save calibration result to SW memory\n");
        #endif
    }
    else
    {
        mcSHOW_DBG_MSG("[FAST_K] Bypass saving calibration result to emmc\n");
    }

	return DRAM_OK;
}

DRAM_STATUS_T DramcSave_Time_For_Cal_Init(DRAMC_CTX_T *p)
{
    if (!u1IsLP4Family(p->dram_type))
        return DRAM_FAIL;

	if (doe_get_config("fullk"))
		return DRAM_FAIL;

    // Parepare fask k data
    #if EMMC_READY
    // scy: only need to read emmc one time for each boot-up
    //if (g_dram_save_time_init_done == 1)
    //    return DRAM_OK;
    //else
    //    g_dram_save_time_init_done = 1;
    if (read_offline_dram_calibration_data(p->shu_type, p->pSavetimeData) < 0)
        {
        p->femmc_Ready = 0;
        memset(p->pSavetimeData, 0, sizeof(SAVE_TIME_FOR_CALIBRATION_T));
        }
        else
        {
        p->femmc_Ready = 1;
        }

    #else //EMMC is not avaliable, load off-line data

    if (g_dram_save_time_init_done[p->shu_type] == 0)
    {
        p->femmc_Ready = 0;
        memset(p->pSavetimeData, 0, sizeof(SAVE_TIME_FOR_CALIBRATION_T));
    }
    else
    {
        memcpy(p->pSavetimeData, &(SaveTimeDataByShuffle[p->shu_type]), sizeof(SAVE_TIME_FOR_CALIBRATION_T));
        p->femmc_Ready = 1;
    }
    #endif

    if (p->femmc_Ready == 1)
    {
        if (p->frequency < 1600)
        {   // freq < 1600, TX and RX tracking are disable. Therefore, bypass calibration.
            p->Bypass_RDDQC = 1;
            p->Bypass_RXWINDOW = 1;
            p->Bypass_TXWINDOW = 1;
    }
    else
    {
            p->Bypass_RDDQC = 1;
            p->Bypass_RXWINDOW = 0;
            p->Bypass_TXWINDOW = 0;
    }

#if RUNTIME_SHMOO_RELEATED_FUNCTION
        p->Bypass_RDDQC = 1;
        p->Bypass_RXWINDOW = 1;
        p->Bypass_TXWINDOW = 1;
#endif
    }

#if EMMC_READY
    mcSHOW_DBG_MSG("[FAST_K] DramcSave_Time_For_Cal_Init SHU%d, femmc_Ready=%d\n", p->shu_type, p->femmc_Ready);
#else
    mcSHOW_DBG_MSG("[FAST_K] DramcSave_Time_For_Cal_Init SHU%d, Init_done=%d, femmc_Ready=%d\n", p->shu_type, g_dram_save_time_init_done[p->shu_type], p->femmc_Ready);
#endif
    mcSHOW_DBG_MSG("[FAST_K] Bypass_RDDQC %d, Bypass_RXWINDOW=%d, Bypass_TXWINDOW=%d\n", p->Bypass_RDDQC, p->Bypass_RXWINDOW, p->Bypass_TXWINDOW);

    return DRAM_OK;
}
#endif

#if ENABLE_RANK_NUMBER_AUTO_DETECTION
void DramRankNumberDetection(DRAMC_CTX_T *p)
{
    U8 u1RankBak;

    u1RankBak = u1GetRank(p);  // backup current rank setting

    vSetPHY2ChannelMapping(p, CHANNEL_A); // when switching channel, must update PHY to Channel Mapping
    vSetRank(p, RANK_1);

    #if DDR_ENABLE_WRITE_LEVELING_CAL
    if (DramcWriteLeveling(p, AUTOK_OFF, PI_BASED) == DRAM_OK)
    {
        p->support_rank_num = RANK_DUAL;
        vIO32WriteFldAlign(DRAMC_REG_SA_RESERVE, 0, SA_RESERVE_SINGLE_RANK);  //keep support_rank_num to reserved rg
    }
    else
    #endif
    {
        p->support_rank_num = RANK_SINGLE;
        vIO32WriteFldAlign(DRAMC_REG_SA_RESERVE, 1, SA_RESERVE_SINGLE_RANK);  //keep support_rank_num to reserved rg
    }
    mcSHOW_DBG_MSG("[RankNumberDetection] %d\n", p->support_rank_num);

    vSetRank(p, u1RankBak);  // restore rank setting
}
#endif

void vCalibration_Flow_For_MDL(DRAMC_CTX_T *p)
{
    U8 u1RankMax;
    S8 s1RankIdx;

#if (DDR_ENABLE_GATING_CAL && DDR_GATING_ADJUST_TXDLY_FOR_TRACKING)
    DramcRxdqsGatingPreProcess(p);
#endif

    if (p->support_rank_num == RANK_DUAL)
        u1RankMax = RANK_MAX;
    else
        u1RankMax = RANK_1;

    for (s1RankIdx = RANK_0; s1RankIdx < u1RankMax; s1RankIdx++)
    {
        vSetRank(p, s1RankIdx);

        vAutoRefreshSwitch(p, ENABLE); //when doing gating, RX and TX calibration, auto refresh should be enable
        #if DDR_ENABLE_GATING_CAL
        dramc_rx_dqs_gating_cal(p, AUTOK_OFF, 0);
        #endif

        #if DDR_ENABLE_RX_RDDQC_CAL
        DramcRxWindowPerbitCal(p, PATTERN_RDDQC, NULL, AUTOK_OFF);
        #endif

#if MRW_CHECK_ONLY
        mcSHOW_MRW_MSG("\n==[MR Dump] %s==\n", __func__);
#endif
        vAutoRefreshSwitch(p, DISABLE); //After gating, Rx and Tx calibration, auto refresh should be disable
    }

    vSetRank(p, RANK_0); // Set p's rank back to 0 (Avoids unexpected auto-rank offset calculation in u4RegBaseAddrTraslate())

#if (DDR_ENABLE_GATING_CAL && DDR_GATING_ADJUST_TXDLY_FOR_TRACKING)
    DramcRxdqsGatingPostProcess(p);
#endif
}

int GetDramInforAfterCalByMRR(DRAMC_CTX_T *p, DRAM_INFO_BY_MRR_T *DramInfo)
{
    return 0;
}

static void vCalibration_Flow_PCDDR(DRAMC_CTX_T *p)
{
    U8 u1RankMax;
    S8 s1RankIdx;
    //DRAM_STATUS_T VrefStatus;

#ifdef DDR_INIT_TIME_PROFILING
    U32 CPU_Cycle;
    TimeProfileBegin();
#endif

#if __Petrus_TO_BE_PORTING__
#if DDR_ENABLE_RX_INPUT_BUF_CAL  // skip when bring up
    ///TODO: no shuffle, only need to do once under highest freq.
    if(p->frequency == u2DFSGetHighestFreq(p))
    DramcRXInputBufferOffsetCal(p);

#ifdef DDR_INIT_TIME_PROFILING
    CPU_Cycle=TimeProfileEnd();
    mcSHOW_TIME_MSG("\tRX input cal takes %d us\n", CPU_Cycle);
    TimeProfileBegin();
#endif
#endif
#endif


#if (DDR_ENABLE_GATING_CAL && DDR_GATING_ADJUST_TXDLY_FOR_TRACKING)
    DramcRxdqsGatingPreProcess(p);
#endif

    if (p->support_rank_num == RANK_DUAL)
        u1RankMax = RANK_MAX;
    else
        u1RankMax = RANK_1;

    //vAutoRefreshSwitch(p, DISABLE); //auto refresh is set as disable in LP4_DramcSetting, so don't need to disable again
    vAutoRefreshSwitch(p, DISABLE);

    for(s1RankIdx = RANK_0; s1RankIdx < u1RankMax; s1RankIdx++)
    {
        vSetRank(p, s1RankIdx);

#if DDR_ENABLE_WRITE_LEVELING_CAL
#if FOR_DV_SIMULATION_USED
        if (SASimCtlGlobal.sim_wl)
#endif
        {
            mcSHOW_DBG_MSG("\n----->DramcWriteLeveling(PI) begin...\n");

            DramcWriteLeveling(p, AUTOK_OFF, PI_BASED);

            mcSHOW_DBG_MSG("DramcWriteLeveling(PI) end<-----\n\n");

            #ifdef DDR_INIT_TIME_PROFILING
            CPU_Cycle=TimeProfileEnd();
            mcSHOW_TIME_MSG("\tRank %d Write leveling takes %d us\n", s1RankIdx, CPU_Cycle);
            TimeProfileBegin();
            #endif
        }
#endif /* (DDR_ENABLE_WRITE_LEVELING_CAL == 1) */

        #if LJPLL_FREQ_DEBUG_LOG
        DDRPhyFreqMeter();
        #endif

#if DDR_ENABLE_GATING_CAL
#if FOR_DV_SIMULATION_USED
        if (SASimCtlGlobal.sim_dqsg)
#endif
        {
#if __SLT__
            mcSHOW_SLT_MSG(("dramc_rx_dqs_gating_cal \n\n"));
#endif
            dramc_rx_dqs_gating_cal(p, AUTOK_OFF, 0);

            #ifdef DDR_INIT_TIME_PROFILING
            CPU_Cycle=TimeProfileEnd();
            mcSHOW_TIME_MSG("\tRank %d Gating takes %d us\n", s1RankIdx, CPU_Cycle);
            TimeProfileBegin();
            #endif
        }
#endif

        #if LJPLL_FREQ_DEBUG_LOG
            DDRPhyFreqMeter();
        #endif

#if DDR_ENABLE_RX_RDDQC_CAL
#if FOR_DV_SIMULATION_USED
        if (SASimCtlGlobal.sim_rddqc)
#endif
        {
#if __SLT__
            mcSHOW_SLT_MSG(("DramcRxWindowPerbitCal PATTERN_RDDQC u1VrefScanEnable = NULL \n\n"));
#endif
            DramcRxWindowPerbitCal(p, PATTERN_RDDQC, NULL, AUTOK_OFF);

            #ifdef DDR_INIT_TIME_PROFILING
            CPU_Cycle=TimeProfileEnd();
            mcSHOW_TIME_MSG("\tRank %d RX RDDQC takes %d us\n", s1RankIdx, CPU_Cycle);
            TimeProfileBegin();
            #endif
        }
#endif

        #if LJPLL_FREQ_DEBUG_LOG
            DDRPhyFreqMeter();
        #endif

#if MRW_CHECK_ONLY
        mcSHOW_MRW_MSG("\n==[MR Dump] %s==\n", __func__);
#endif

#if DDR_ENABLE_TX_PERBIT_CAL
#if FOR_DV_SIMULATION_USED
        if (SASimCtlGlobal.sim_tx)
#endif
        {
#if __SLT__
            mcSHOW_SLT_MSG(("DramcTxWindowPerbitCal TX_DQ_DQS_MOVE_DQ_DQM u1VrefScanEnable = FALSE \n\n"));
#endif
            DramcTxWindowPerbitCal(p, TX_DQ_DQS_MOVE_DQ_DQM, FALSE, AUTOK_OFF);

            if (Get_Vref_Calibration_OnOff(p) == VREF_CALI_ON)
            {
#if __SLT__
                mcSHOW_SLT_MSG(("DramcTxWindowPerbitCal TX_DQ_DQS_MOVE_DQ_ONLY u1VrefScanEnable = TRUE \n\n"));
#endif
                DramcTxWindowPerbitCal(p, TX_DQ_DQS_MOVE_DQ_ONLY, TRUE, AUTOK_OFF);
            }

            #if PINMUX_AUTO_TEST_PER_BIT_TX
            CheckTxPinMux(p);
            #endif
#if __SLT__
            mcSHOW_SLT_MSG(("DramcTxWindowPerbitCal TX_DQ_DQS_MOVE_DQ_ONLY u1VrefScanEnable = FALSE \n\n"));
#endif
            DramcTxWindowPerbitCal(p, TX_DQ_DQS_MOVE_DQ_ONLY, FALSE, AUTOK_OFF);

            #if !FOR_DV_SIMULATION_USED
            #if (TX_K_DQM_MODE == 1) && DDR_TX_K_DQM_WITH_WDBI
            if ((p->DBI_W_onoff[p->dram_fsp]==DBI_ON))
            {
                // K DQM with DBI_ON, and check DQM window spec.
                //mcSHOW_DBG_MSG("[DDR_TX_K_DQM_WITH_WDBI] Step1: K DQM with DBI_ON, and check DQM window spec.\n\n");
                vSwitchWriteDBISettings(p, DBI_ON);
                DramcTxWindowPerbitCal((DRAMC_CTX_T *) p, TX_DQ_DQS_MOVE_DQM_ONLY, FALSE, AUTOK_OFF);
                vSwitchWriteDBISettings(p, DBI_OFF);
            }
            #elif (TX_K_DQM_MODE == 2)
            DramcTxWindowPerbitCal((DRAMC_CTX_T *) p, TX_DQ_DQS_MOVE_DQM_ONLY, FALSE, AUTOK_OFF);
            #endif
            #endif

            #if ENABLE_EYESCAN_GRAPH && !FOR_DV_SIMULATION_USED
            Dramc_K_TX_EyeScan_Log(p);
            print_EYESCAN_LOG_message(p, 2); //draw TX eyescan
            #endif

            #ifdef DDR_INIT_TIME_PROFILING
            CPU_Cycle=TimeProfileEnd();
            mcSHOW_TIME_MSG("\tRank %d TX calibration takes %d us\n", s1RankIdx, CPU_Cycle);
            TimeProfileBegin();
            #endif
        }
#endif

    #if ENABLE_DDR_CS_ADJUST
        DramcAdjustCommandBus(p);
    #endif
        #if LJPLL_FREQ_DEBUG_LOG
            DDRPhyFreqMeter();
        #endif

#if DDR_ENABLE_DATLAT_CAL
#if FOR_DV_SIMULATION_USED
        if (SASimCtlGlobal.sim_datlat)
#endif
        {
            DramcRxdatlatCal(p);

            #ifdef DDR_INIT_TIME_PROFILING
            CPU_Cycle=TimeProfileEnd();
            mcSHOW_TIME_MSG("\tRank %d Datlat takes %d us\n", s1RankIdx, CPU_Cycle);
            TimeProfileBegin();
            #endif
        }
#endif

        #if LJPLL_FREQ_DEBUG_LOG
            DDRPhyFreqMeter();
        #endif


#if DDR_ENABLE_RX_PERBIT_CAL
#if FOR_DV_SIMULATION_USED
        if (SASimCtlGlobal.sim_rx)
#endif
        {
            #if PINMUX_AUTO_TEST_PER_BIT_RX
            CheckRxPinMux(p);
            #endif
#if __SLT__
            mcSHOW_SLT_MSG(("DramcRxWindowPerbitCal PATTERN_TEST_ENGINE u1VrefScanEnable = NULL \n\n"));
#endif
            DramcRxWindowPerbitCal(p, PATTERN_TEST_ENGINE, NULL /*Set Vref = 0 to test*/, AUTOK_OFF);

            #ifdef DDR_INIT_TIME_PROFILING
            CPU_Cycle=TimeProfileEnd();
            mcSHOW_TIME_MSG("\tRank %d RX calibration takes %d us\n", s1RankIdx, CPU_Cycle);
            TimeProfileBegin();
            #endif
           // DramcRxdqsGatingCal(p);
        }
#endif

#if ENABLE_EYESCAN_GRAPH
        print_EYESCAN_LOG_message(p, 1); //draw RX eyescan
#endif

#if DDR_ENABLE_RX_DVS_CAL
    if (p->frequency >=2133)
        DramcRxDVSWindowCal(p);
#endif

#if DDR_ENABLE_TX_OE_CAL && !ENABLE_WDQS_MODE_2
        if(p->frequency >= 1600)
        {
            DramcTxOECalibration(p);
        }
#endif

        #if DDR_ENABLE_TX_TRACKING
        DramcDQSOSCSetMR18MR19(p);
        DramcDQSOSCMR23(p);
        #endif

    }

#if __Petrus_TO_BE_PORTING__
    #if SUPPORT_SAVE_TIME_FOR_CALIBRATION
    if(p->femmc_Ready==0)
    #endif
    {
        if(p->frequency >= RX_VREF_DUAL_RANK_K_FREQ)  // for 3733/4266
        {
            U8 u1ByteIdx, u1HighFreqRXVref[2];
            for(u1ByteIdx =0 ; u1ByteIdx<(p->data_width/DQS_BIT_NUMBER); u1ByteIdx++)
            {
                u1HighFreqRXVref[u1ByteIdx] = (gFinalRXVrefDQ[p->channel][RANK_0][u1ByteIdx] + gFinalRXVrefDQ[p->channel][RANK_1][u1ByteIdx]) >> 1;
                mcSHOW_DBG_MSG("RX Vref Byte%d (u1HighFreqRXVref) = %d = (%d+ %d)>>1\n", u1ByteIdx, u1HighFreqRXVref[u1ByteIdx], gFinalRXVrefDQ[p->channel][RANK_0][u1ByteIdx], gFinalRXVrefDQ[p->channel][RANK_1][u1ByteIdx]);
            }

            for(s1RankIdx=RANK_0; s1RankIdx < u1RankMax; s1RankIdx++)
            {
                vSetRank(p, s1RankIdx);
                DramcRxWindowPerbitCal((DRAMC_CTX_T *) p, 1, u1HighFreqRXVref);
            }
        }
    }
#endif

    vSetRank(p, RANK_0); // Set p's rank back to 0 (Avoids unexpected auto-rank offset calculation in u4RegBaseAddrTraslate())

    #if DDR_ENABLE_TX_TRACKING
    DramcDQSOSCShuSettings(p);
    #endif

#if (DDR_ENABLE_GATING_CAL && DDR_GATING_ADJUST_TXDLY_FOR_TRACKING)
    DramcRxdqsGatingPostProcess(p);
#endif

#if TDQSCK_PRECALCULATION_FOR_DVFS && DDR_DFS_ENABLE
    DramcDQSPrecalculation_preset(p);
#endif

#if DDR_ENABLE_RX_DVS_CAL
    if (p->frequency >=2133)
        DramcDramcRxDVSCalPostProcess(p);
#endif

#if DDR_ENABLE_DATLAT_CAL
#if FOR_DV_SIMULATION_USED
    if (SASimCtlGlobal.sim_datlat)
#endif
    {
        DramcDualRankRxdatlatCal(p);
    }
#endif

#if DDR_RDSEL_TRACKING_EN
    if (p->frequency >= 1866)
        RDSELRunTimeTracking_preset(p);
#endif

#if __IPMv2_TO_BE_PORTING__
#if XRTWTW_NEW_CROSS_RK_MODE
    if(p->support_rank_num == RANK_DUAL)
    {
        XRTWTW_SHU_Setting(p);
    }
#endif
#endif

#if __Petrus_TO_BE_PORTING__
#if LJPLL_FREQ_DEBUG_LOG
    DDRPhyFreqMeter();
#endif
#endif

    #ifdef DDR_INIT_TIME_PROFILING
    CPU_Cycle=TimeProfileEnd();
    mcSHOW_TIME_MSG("\tMisc takes %d us\n\n", s1RankIdx, CPU_Cycle);
    #endif
}

static void vDramCalibrationSingleChannel(DRAMC_CTX_T *p)
{
#if !__ETT__
    /*
     * Since DRAM calibration will cost much time,
     * kick wdt here to prevent watchdog timeout.
     */
#if (FOR_DV_SIMULATION_USED == 0)
    //mtk_wdt_restart();//porting later
#endif
#endif

    vCalibration_Flow_PCDDR(p);
}

void vDramCalibrationAllChannel(DRAMC_CTX_T *p)
{
    U8 channel_idx;
	#if DDR_ENABLE_WRITE_DBI
	U8 rank_idx;
	#endif
#ifdef DDR_INIT_TIME_PROFILING
    U32 u4low_tick0, u4high_tick0, u4low_tick1, u4high_tick1;
#if __ETT__
    u4low_tick0 = GPT_GetTickCount(&u4high_tick0);
#else
    u4low_tick0 = get_timer(0);
#endif
#endif

    for (channel_idx = CHANNEL_A; channel_idx < p->support_channel_num; channel_idx++)
    {
        vSetPHY2ChannelMapping(p, channel_idx);// when switching channel, must update PHY to Channel Mapping
        vDramCalibrationSingleChannel(p);
    }

    vSetPHY2ChannelMapping(p, CHANNEL_A);

#if PRINT_CALIBRATION_SUMMARY
    vPrintCalibrationResult(p);
#endif

#ifdef FOR_HQA_TEST_USED
    #if SUPPORT_SAVE_TIME_FOR_CALIBRATION
    if (p->femmc_Ready == 1)
    {
        mcSHOW_DBG_MSG("\nCalibration fast K is enable, cannot show HQA measurement information\n");
    }
    else
    #endif
    print_HQA_measure_message(p);
#endif

    /* Enable/Disable calibrated rank's DBI function accordingly */
#if DDR_ENABLE_READ_DBI
	//Read DBI ON
	vSetRank(p, RANK_0);
	vSetPHY2ChannelMapping(p, CHANNEL_A);

	DramcReadDBIOnOff(p, p->DBI_R_onoff[p->dram_fsp]);
#endif

#if DDR_ENABLE_WRITE_DBI
    // Just settle the DBI parameters which would be stored into shuffle space.
    if (p->DBI_W_onoff[p->dram_fsp])
    {
        for (channel_idx = CHANNEL_A; channel_idx < p->support_channel_num; channel_idx++)
        {
            vSetPHY2ChannelMapping(p, channel_idx);

            for (rank_idx = RANK_0; rank_idx < RANK_MAX; rank_idx++)
            {
                vSetRank(p, rank_idx);
                DramcWriteShiftMCKForWriteDBI(p, -1); //Tx DQ/DQM -1 MCK for write DBI ON
            }
            vSetRank(p, RANK_0);
        }
        vSetPHY2ChannelMapping(p, CHANNEL_A);

        // Improve Write DBI Power
        ApplyWriteDBIPowerImprove(p, ENABLE);

        #if ENABLE_WRITE_DBI_Protect
        ApplyWriteDBIProtect(p, ENABLE);
        #endif
    }

    DramcWriteDBIOnOff(p, p->DBI_W_onoff[p->dram_fsp]);
#endif

#if TX_PICG_NEW_MODE
    TXPICGSetting(p);
#endif

#if XRTRTR_NEW_CROSS_RK_MODE
    if (p->support_rank_num == RANK_DUAL)
    {
        XRTRTR_SHU_Setting(p);
    }
#endif

#if (DDR_ENABLE_TX_TRACKING || DDR_TDQSCK_PRECALCULATION_FOR_DVFS)
    FreqJumpRatioCalculation(p);
#endif

#if DDR_TEMP_SENSOR_ENABLE
    DramcHMR4_Presetting(p);
#endif

#if (DDR_ENABLE_PER_BANK_REFRESH == 1)
    DramcEnablePerBankRefresh(p, ON);
#else
    DramcEnablePerBankRefresh(p, OFF);
#endif

#if DDR_DRAMC_MODIFIED_REFRESH_MODE
    DramcModifiedRefreshMode(p);
#endif

#if DDR_DRAMC_CKE_DEBOUNCE
    DramcCKEDebounce(p);
#endif

#if DDR_ENABLE_TX_TRACKING
    U8 backup_channel = p->channel;
    U8 channelIdx;

    for (channelIdx = CHANNEL_A; channelIdx < p->support_channel_num; channelIdx++)
    {
        vSetPHY2ChannelMapping(p, channelIdx);
        DramcHwDQSOSC(p);
    }

    vSetPHY2ChannelMapping(p, backup_channel);
    mcSHOW_DBG_MSG("TX_TRACKING: ON\n");
#else
    mcSHOW_DBG_MSG("TX_TRACKING: OFF\n");
#endif

#if DDR_ENABLE_DFS_RUNTIME_MRW
    DFSRuntimeMRW_preset(p, vGet_Current_ShuLevel(p));
#endif

#ifdef DDR_INIT_TIME_PROFILING
#if __ETT__
    u4low_tick1 = GPT_GetTickCount(&u4high_tick1);
    mcSHOW_TIME_MSG(("  (4) vDramCalibrationAllChannel() take %d ms\n\r", (u4low_tick1 - u4low_tick0) * 76) / 1000000);
#else
    u4low_tick1 = get_timer(u4low_tick0);
    mcSHOW_TIME_MSG("  (4) vDramCalibrationAllChannel() take %d ms\n\r", u4low_tick1);
#endif
#endif
}

U8 gGet_MDL_Used_Flag = 0;
void Set_MDL_Used_Flag(U8 value)
{
    gGet_MDL_Used_Flag = value;
}

U8 Get_MDL_Used_Flag(void)
{
    return gGet_MDL_Used_Flag;
}

void Init_DramcSwImpedanceCal(DRAMC_CTX_T *p)
{
    mcSHOW_DBG_MSG("dram type %d \n",MEM_TYPE);

#if DDR_ENABLE_SW_IMPED_CAL
#if FOR_DV_SIMULATION_USED
	if (SASimCtlGlobal.sim_sw_imp)
#endif
	{
        DramcSwImpedanceCal(p);
	}
#endif
}

#if 0
#ifndef LOOPBACK_TEST
#if DDR_ENABLE_SW_IMPED_CAL
#if FOR_DV_SIMULATION_USED
    if (SASimCtlGlobal.sim_sw_imp)
#endif
    {
        if (p->dram_type == TYPE_LPDDR4X) // LP4/LP4P need confirm
        {
            // LP4 IMP_LOW_FREQ <= DDR3733, IMP_HIGH_FREQ >= DDR4266
            // LP5 IMP_LOW_FREQ <= DDR3733, IMP_HIGH_FREQ >= DDR4266
            DramcSwImpedanceCal(p, 1, IMP_LOW_FREQ);
            DramcSwImpedanceCal(p, 1, IMP_HIGH_FREQ);
        #if ENABLE_SAMSUNG_NT_ODT
            DramcSwImpedanceCal(p, 1, IMP_NT_ODTN); // for Samsung NT ODTN
        #endif
        }
        else
        {
            mcSHOW_ERR_MSG("[DramcSwImpedanceCal] Warnning: Need confirm DRAM type for SW IMP Calibration !!!\n");
        #if __ETT__
            while (1);
        #endif
        }
    }
#endif
#endif
#endif

void Init_DramcCalibrationAllFreq(DRAMC_CTX_T *p, DRAM_INFO_BY_MRR_T *DramInfo)
{
    vDramCalibrationAllChannel(p);
    GetDramInforAfterCalByMRR(p, DramInfo);
#if __IPMv2_TO_BE_PORTING__
    vDramcACTimingOptimize(p);
#endif

#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
    DramcSave_Time_For_Cal_End(p);
#endif //((!defined(FIRST_BRING_UP)) || (ENABLE_DRAM_SINGLE_FREQ_SELECT != 0xFF)) && (!__FLASH_TOOL_DA__)
}

void Init_Dram_Ctx_By_Type(DRAMC_CTX_T *p, DRAM_DRAM_TYPE_T dram_type)
{
    p->dram_type = dram_type;

    if (is_ddr3_family(p)) {
        MEM_TYPE = PCDDR3;

        if (mt7987_ddr3_freq == 1866)
            gFreqTbl_PC3[0].freq_sel = DDR3_DDR1866;

        gFreqTbl = gFreqTbl_PC3;
        p->u1DFSTableSize = u1FreqTblCnt_PC3;
    } else if (is_ddr4_family(p)) {
        MEM_TYPE = PCDDR4;

        if (mt7987_ddr4_freq == 2667)
            gFreqTbl_PC4[0].freq_sel = DDR4_DDR2667;

        gFreqTbl = gFreqTbl_PC4;
        p->u1DFSTableSize = u1FreqTblCnt_PC4;
    } else {
        ASSERT(0);
    }
}

DRAMC_CTX_T *psCurrDramCtx = &DramContext;
U8 gfirst_init_flag = 0;
int Init_DRAM(DRAM_DRAM_TYPE_T dram_type, DRAM_CBT_MODE_EXTERN_T dram_cbt_mode_extern, DRAM_INFO_BY_MRR_T *DramInfo, U8 get_mdl_used)
{
#if (__ETT__ && CPU_RW_TEST_AFTER_K)
    int s4value;
#endif
#if __SLT__
	mcSHOW_SLT_MSG(("\n This is for SLT build \n"));
#endif

	mcSHOW_DBG_MSG("\n%s:%d: init %s dram Start\n", __func__, __LINE__, (dram_type == TYPE_DDR4) ? "PCDDR4":"PCDDR3");

    DRAMC_CTX_T * p;

#ifdef DDR_INIT_TIME_PROFILING
    U32 CPU_Cycle;
    TimeProfileBegin();
#endif

    Init_Dram_Ctx_By_Type(psCurrDramCtx, dram_type);

#if defined(DDR_INIT_TIME_PROFILING) || (__ETT__ && SUPPORT_SAVE_TIME_FOR_CALIBRATION)
    if (gtime_profiling_flag == 0)
    {
        memcpy(&gTimeProfilingDramCtx, psCurrDramCtx, sizeof(DRAMC_CTX_T));
        gtime_profiling_flag = 1;
    }

    p = &gTimeProfilingDramCtx;
    gfirst_init_flag = 0;

    //DramcConfInfraReset(p);  //No need when DDR_INIT_TIME_PROFILING_TEST_CNT=1
#else
    p = psCurrDramCtx;
#endif

    Set_MDL_Used_Flag(get_mdl_used);

#if ENABLE_APB_MASK_WRITE
    U32 u4GPTTickCnt;
    TimeProfileBegin();

    EnableDramcAPBMaskWrite(p);
    DramcRegAPBWriteMask(p);

    u4GPTTickCnt = TimeProfileEnd();
    mcSHOW_TIME_MSG("[DramcRegAPBWriteMask] take %d ms\n", u4GPTTickCnt / 1000);

    TestAPBMaskWriteFunc(p);

    while (1);
#endif

    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);   //LP4 broadcast on

    if (gfirst_init_flag == 0)
    {
        MPLLInit();
	Set_DRAM_Pinmux_Sel(p);
        DramcDUTTopSet(p, NULL);
    #if IPM_VERSION >= 21
        MD32_initializaton(p);
    #endif
        Global_Option_Init(p);
        gfirst_init_flag = 1;
    }

#ifdef FIRST_BRING_UP
    Test_Broadcast_Feature(p);
#endif

#if DRAMC_CTRL_BY_SOC
    {
        U32 backup_broadcast;
        backup_broadcast = GetDramcBroadcast();
        DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);
        mdl_setting(p);
        TA2_Test_Run_Time_HW_Set_Column_Num(p);
        DramcBroadcastOnOff(backup_broadcast);
    }
#endif

    mcSHOW_DBG_MSG("\n\n[Bian_co] ETT version 0.0.0.1\n dram_type %d, R0 cbt_mode %d, R1 cbt_mode %d VENDOR=%d\n\n", p->dram_type, p->dram_cbt_mode[RANK_0], p->dram_cbt_mode[RANK_1], p->vendor_id);

#if __Petrus_TO_BE_PORTING__
    vDramcInit_PreSettings(p);
#endif

    vSetDFSFreqSelByTable(p, gFreqTbl);

#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
    DramcSave_Time_For_Cal_Init(p);
#endif

    DramcDUTShuSet(p, NULL, DRAM_DFS_REG_SHU0);
    DramcHWFuncSet(p, NULL);

    dump_dramc_ctx(p);

    Init_DramcSwImpedanceCal(p);

#ifdef DDR_INIT_TIME_PROFILING
    CPU_Cycle = TimeProfileEnd();
    mcSHOW_TIME_MSG("(0)Pre_Init + SwImdepance takes %d ms\n\r", CPU_Cycle / 1000);
#endif

#ifdef DUMP_INIT_RG_LOG_TO_DE
    gDUMP_INIT_RG_LOG_TO_DE_RG_log_flag = 1;
    mcSHOW_DUMP_INIT_RG_MSG("\n\n//=== DDR\033[1;32m%d\033[m\n",p->frequency<<1);
#endif

    DFSInitForCalibration(p);

#ifdef TEST_MODE_MRS
    if (global_which_test == 0)
        TestModeTestMenu();
#endif


#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
    if (p->femmc_Ready==1)
    {
        p->support_rank_num = p->pSavetimeData->support_rank_num;
    }
    else
#endif
    {
#if ENABLE_RANK_NUMBER_AUTO_DETECTION && !FOR_DV_SIMULATION_USED
        if (Get_MDL_Used_Flag()==GET_MDL_USED)
        {
            DramRankNumberDetection(p);
            DFSInitForCalibration(p);  // Restore setting after rank dection (especially DQ= DQS+16)
        }
#endif

#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
        p->pSavetimeData->support_rank_num = p->support_rank_num;
#endif
    }

    #if DRAMC_CTRL_BY_SOC
    U32 backup_broadcast;
    backup_broadcast = GetDramcBroadcast();
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);
    //emi_init2();
    DramcBroadcastOnOff(backup_broadcast);
    #endif

    if (Get_MDL_Used_Flag()==GET_MDL_USED)
    {
        // only K CHA to save time
        vSetPHY2ChannelMapping(p, CHANNEL_A);
        vCalibration_Flow_For_MDL(p); // currently for LP4
        GetDramInforAfterCalByMRR(p, DramInfo);
        return 0;
    }

    Init_DramcCalibrationAllFreq(p, DramInfo);

#ifdef DDR_INIT_TIME_PROFILING
    TimeProfileBegin();
#endif

    vAfterCalibration(p);

    set_emi_cona_by_size(p);

#ifdef ENABLE_POST_PACKAGE_REPAIR
    PostPackageRepair();
#endif

#if __Petrus_TO_BE_PORTING__

#if !LCPLL_IC_SCAN
#if (FOR_DV_SIMULATION_USED == 0)
    print_DBG_info(p);
    Dump_EMIRegisters(p);
#endif
#endif

#if 0
    DramcRegDump(p, SRAM_SHU0);
#endif

// ETT_NO_DRAM #endif

#if ETT_NO_DRAM
    //NoDramDramcRegDump(p);
    NoDramRegFill();
#endif
#endif //#if __Petrus_TO_BE_PORTING__

    #if 0 //DRAMC_MODEREG_CHECK
    DramcModeReg_Check(p);
    #endif

    #if __FLASH_TOOL_DA__
    vPrintPinInfoResult(p);
    vGetErrorTypeResult(p);
    #endif

    #if (!FOR_DV_SIMULATION_USED && CPU_RW_TEST_AFTER_K)
    mcSHOW_DBG_MSG("\n[MEM_TEST] 02: After DFS, before run time config\n");
    vDramCPUReadWriteTestAfterCalibration(p);
    #endif

    #if (!FOR_DV_SIMULATION_USED && TA2_RW_TEST_AFTER_K)
    mcSHOW_DBG_MSG("\n[TA2_TEST]\n");
    TA2_Test_Run_Time_HW(p);
    #endif

#if __ETT__
#if SUPPORT_SAVE_TIME_FOR_CALIBRATION
    if (!(p->femmc_Ready == 0))
#elif defined(DDR_INIT_TIME_PROFILING)
if (u2TimeProfileCnt == (DDR_INIT_TIME_PROFILING_TEST_CNT - 1)) //last time of loop
#endif
#endif
    {
        #if DUMP_ALLSHU_RG
        mcDUMP_REG_MSG("\n[dumpRG] BeforeRunTimeConfig\n");
        DumpAllChAllShuRG(p);
        #endif

        DramcRunTimeConfig(p);


        #if DUMP_ALLSHU_RG
        mcDUMP_REG_MSG("\n[dumpRG] AfterRunTimeConfig\n");
        DumpAllChAllShuRG(p);
        #endif
    }

#if (!FOR_DV_SIMULATION_USED && CPU_RW_TEST_AFTER_K)
    mcSHOW_DBG_MSG("\n[MEM_TEST] 03: After run time config\n");
    vDramCPUReadWriteTestAfterCalibration(p);
#endif

#if (!FOR_DV_SIMULATION_USED && TA2_RW_TEST_AFTER_K)
    mcSHOW_DBG_MSG("\n[TA2_TEST]\n");
    TA2_Test_Run_Time_HW(p);
#endif
#if 0//__SLT__
	if(p->DRAMPinmux == PINMUX_EMCP){
        mcSHOW_SLT_MSG(("\n[TA2_FULL_RANGE_TEST]\n"));
        TA2_Test_Run_Time_HW_FULL_SIZE(p);
	}
#endif

#if (__ETT__ && CPU_RW_TEST_AFTER_K)
    /* 0x46000000 is LK base addr */
    //while(1)
    {
        //if ((s4value = dramc_complex_mem_test (0x46000000, 0x2000)) == 0)
        if ((s4value = dramc_complex_mem_test (0x40024000, 0x20000)) == 0)
        {
            mcSHOW_DBG_MSG("1st complex R/W mem test pass\n");
        }
        else
        {
            mcSHOW_DBG_MSG("1st complex R/W mem test fail :-%d\n", -s4value);
#if defined(SLT)
            mcSHOW_ERR_MSG("[dramc] DRAM_FATAL_ERR_FLAG = 0x80000000\n");
            while (1);
#endif
        }
    }
#endif

#if MRW_CHECK_ONLY
    vPrintFinalModeRegisterSetting(p);
#endif

#ifdef DDR_INIT_TIME_PROFILING
    CPU_Cycle = TimeProfileEnd();
    mcSHOW_TIME_MSG("  (5) After calibration takes %d ms\n\r", CPU_Cycle / 1000);
#endif  // end of DDR_INIT_TIME_PROFILING

    //Low_Power_Scenarios_Test(p);

#ifndef DPM_CONTROL_AFTERK
    dramc_exit_with_DFS_legacy_mode(p);
#endif

    //PCDDR_SetDFSFreqSelByTable(p, get_FreqTbl_by_shuffleIndex(p, SRAM_SHU1));
    //DramcDFSDirectJump(p, SRAM_SHU1);//Switch to CLRPLL
    //ETT_DRM(p);
    //fe_test();
    return 0;
}
///TODO: wait for porting ---

void dump_dramc_ctx(DRAMC_CTX_T *p)
{
    mcSHOW_DBG_MSG("== DRAMC_CTX_T ==\n");
	mcSHOW_DBG_MSG("support_channel_num:    %d\n", p->support_channel_num);
	mcSHOW_DBG_MSG("channel:                %d\n", p->channel);
	mcSHOW_DBG_MSG("support_rank_num:       %d\n", p->support_rank_num);
	mcSHOW_DBG_MSG("rank:                   %d\n", p->rank);
	mcSHOW_DBG_MSG("freq_sel:               %d\n", p->freq_sel);
	mcSHOW_DBG_MSG("shu_type:               %d\n", p->shu_type);
	mcSHOW_DBG_MSG("dram_type:              %d\n", p->dram_type);
	mcSHOW_DBG_MSG("dram_fsp:               %d\n", p->dram_fsp);
	mcSHOW_DBG_MSG("odt_onoff:              %d\n", p->odt_onoff);
	mcSHOW_DBG_MSG("DBI_R_onoff:            %d, %d\n", (int)p->DBI_R_onoff[0], (int)p->DBI_R_onoff[1]);
	mcSHOW_DBG_MSG("DBI_W_onoff:            %d, %d\n", (int)p->DBI_W_onoff[0], (int)p->DBI_W_onoff[1]);
	mcSHOW_DBG_MSG("data_width:             %d\n", p->data_width);
	mcSHOW_DBG_MSG("test2_1:             0x%x\n", p->test2_1);
	mcSHOW_DBG_MSG("test2_2:             0x%x\n", p->test2_2);
	mcSHOW_DBG_MSG("frequency:              %d\n", p->frequency);
	mcSHOW_DBG_MSG("freqGroup:              %d\n", p->freqGroup);
	mcSHOW_DBG_MSG("u1PLLMode:              %d\n", p->u1PLLMode);
}
