/*
 * Copyright (C) 2022, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Generic secure firmware download internal definitions
 */

#ifndef _FWDL_INTERNAL_H_
#define _FWDL_INTERNAL_H_

#include <common/debug.h>
#include <lib/spinlock.h>
#include <drivers/console.h>
#include "fwdl.h"

#ifdef FWDL_DEBUG
#define FWDL_E				ERROR
#define FWDL_N				NOTICE
#else
#define FWDL_E(x,...)			do {} while (0)
#define FWDL_N(x,...)			do {} while (0)
#endif

#define PAYLOAD_ALIGNMENT			32

#define FW_HDR_VER				1

#define RSA_PSS_SALT_LEN			32
#define RSA_MD_HASH_LEN				32
#define RSA_SIG_LEN				0x100

enum fw_signing_type {
	FW_SIG_NONE,
	FW_SIG_RSA2048_SHA256_PSS,

	__FW_SIG_MAX
};

struct fw_base_header {
	uint32_t magic;				/* @00 */
	uint8_t hdr_ver;			/* @04 */
	uint8_t api_ver;			/* @05 */
	uint16_t hdr_len;			/* @06 */
	uint32_t hdr_crc;			/* @08 */
	uint16_t plat_id;			/* @0C */
	uint16_t flags;				/* @0E */
	uint64_t git_commit_id;			/* @10 */
	uint32_t build_ts;			/* @18 */
	uint8_t role;				/* @1C */
	uint8_t signing_type;			/* @1D */
	uint8_t num_parts;			/* @1E */
	uint8_t part_header_len;		/* @1F */
	uint32_t part_hdr_crc;			/* @20 */
	uint32_t payload_len;			/* @24 */
	uint32_t payload_crc;			/* @28 */
	uint32_t sign_body_len;			/* @2C */
} __attribute__((aligned(4)));

struct fw_part_header {
	uint8_t type;				/* @00 */
	uint8_t unused;				/* @01 */
	uint16_t flags;				/* @02 */
	uint32_t data_size;			/* @04 */
	uint32_t value[2];			/* @08 */
} __attribute__((aligned(4)));

struct fw_rsa_pubkey {
	uint32_t exponent_len;			/* @000 */
	uint32_t modulus_len;			/* @004 */
	uint32_t padding[2];			/* @008 */
	uint8_t exponent[RSA_SIG_LEN];		/* @010 */
	uint8_t modulus[RSA_SIG_LEN];		/* @110 */
} __attribute__((aligned(4)));

/* Image header registration */
struct fw_image_part_data {
	const void *data;
	uint32_t size;
	uint16_t flags;
	uint32_t value[2];
};

struct fw_image_register {
	uint32_t magic;
	const uint8_t *keyhash;

	const uint16_t *plat_ids;
	uint32_t num_plats;

	const uint8_t *role_ids;
	uint32_t num_roles;

	const uint8_t *required_part_types;
	uint32_t num_parts;

	struct fw_image_part_data *part_data;
	enum fwdl_status (*do_fw_load)(struct fw_image_register *fwir,
				       uint16_t plat_id, uint8_t role_id,
				       uint64_t flags);

	spinlock_t load_lock;
};

extern struct fw_image_register tops_fwimg_reg;
extern struct fw_image_register wo_fwimg_reg;

#endif /* _FWDL_INTERNAL_H_ */
