#
# Copyright (c) 2022, MediaTek Inc. All rights reserved.
#
# SPDX-License-Identifier: BSD-3-Clause
#

ifeq ($(FWDL),1)
include drivers/auth/mbedtls/mbedtls_common.mk
PLAT_INCLUDES		+=	-I${MTK_PLAT_SOC}/drivers/fwdl
BL31_SOURCES		+=	${MTK_PLAT_SOC}/drivers/fwdl/fwdl.c		\
				common/tf_crc32.c
BL31_CPPFLAGS		+=	-DFWDL -march=armv8-a+crc

ifeq ($(FWDL_DEBUG),1)
BL31_CPPFLAGS		+=	-DFWDL_DEBUG
endif
ifeq ($(FWDL_ALLOW_NO_SIGNING),1)
BL31_CPPFLAGS		+=	-DFWDL_ALLOW_NO_SIGNING
endif

# TOPS
BL31_SOURCES		+=	${MTK_PLAT_SOC}/drivers/fwdl/tops.c
ifneq ($(TOPS_KEY_HASH),)
BL31_SOURCES		+=	${MTK_PLAT_SOC}/drivers/fwdl/tops-embed-keyhash.S
BL31_CPPFLAGS		+=	-DTOPS_KEY_HASH_PATH=\"$(TOPS_KEY_HASH)\"	\
				-DTOPS_KEY_HASH_VERIFY
endif # TOPS_KEY_HASH

# WO
BL31_SOURCES		+=	${MTK_PLAT_SOC}/drivers/fwdl/wo.c
ifneq ($(WO_KEY_HASH),)
BL31_SOURCES		+=	${MTK_PLAT_SOC}/drivers/fwdl/wo-embed-keyhash.S
BL31_CPPFLAGS		+=	-DWO_KEY_HASH_PATH=\"$(WO_KEY_HASH)\"	\
				-DWO_KEY_HASH_VERIFY
endif # WO_KEY_HASH

include make_helpers/dep.mk

$(call GEN_DEP_RULES,bl31,fwdl tops tops-embed-keyhash wo wo-embed-keyhash)
$(call MAKE_DEP,bl31,fwdl,FWDL_DEBUG FWDL_ALLOW_NO_SIGNING)
$(call MAKE_DEP,bl31,tops,FWDL_DEBUG TOPS_KEY_HASH)
$(call MAKE_DEP,bl31,tops-embed-keyhash,TOPS_KEY_HASH)
$(call MAKE_DEP,bl31,wo,FWDL_DEBUG WO_KEY_HASH)
$(call MAKE_DEP,bl31,wo-embed-keyhash,WO_KEY_HASH)

endif
