/*
 * Copyright (c) 2023, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <lib/mmio.h>
#include <common/debug.h>
#include <drivers/generic_delay_timer.h>
#include <bl2_plat_setup.h>
#include <platform_def.h>
#include <mt7987_gpio.h>
#include <cpuxgpt.h>
#include <pll.h>
#include <emi.h>
#include <mtk_wdt.h>

#define HANG_FREE_PROT_INFRA_AO	0x1000310c

/* CVD may control following variables in the script */
int fpga_use_wdt;
int fpga_use_pcie;

#ifndef FPGA_EMU_WDT_TEST
static void mtk_wdt_init(void)
{
	if (fpga_use_wdt) {
		mtk_wdt_print_status();
		mtk_wdt_control(false);
	} else {
		NOTICE("CPU: Skip '%s'\n", __func__);
	}
}
#endif

static void mtk_print_cpu(void)
{
#if LOG_LEVEL >= LOG_LEVEL_NOTICE
	NOTICE("CPU: MT%x (%dMHz)\n", SOC_CHIP_ID, mtk_get_cpu_freq());
#else
	NOTICE("CPU: MT%x\n", SOC_CHIP_ID);
#endif
}

static void mtk_infra_ao_init(void)
{
	mmio_write_32(HANG_FREE_PROT_INFRA_AO, 0x0);
}

static void mtk_pcie_init(void)
{
	/* Reserved for PCIE owner */
	if (fpga_use_pcie) {
		NOTICE("init PCIE registers...\n");
		// Enable PCIe clocks (FPGA / ASIC)
		INFO("0x10001014=0x00000780\n");
		mmio_write_32(0x10001014, 0x00000780);
		INFO("0x10001064=0xFFF0F000\n");
		mmio_write_32(0x10001064, 0xFFF0F000);
		// Enable PCIe SRAM power (FPGA / AISC)
		INFO("0x10003030=0x00000000\n");
		mmio_write_32(0x10003030, 0x00000000);
		// Force PCIe GEN1 [P0] speed (FPGA only)
		INFO("0x11280080=0x00000081\n");
		mmio_write_32(0x11280080, 0x00000081);
		// Force PCIe GEN1 [P1] speed (FPGA only)
		INFO("0x11290080=0x00000081\n");
		mmio_write_32(0x11290080, 0x00000081);
	}
}

void bl2_el3_plat_arch_setup(void)
{
	plat_mt_cpuxgpt_init();
	generic_delay_timer_init();
}

bool plat_is_my_cpu_primary(void)
{
	return true;
}

const struct initcall bl2_initcalls[] = {
/* BL2 should not access WDT RGs that may break WDT test results */
#ifndef FPGA_EMU_WDT_TEST
	INITCALL(mtk_wdt_init),
#endif
	INITCALL(mtk_print_cpu),
	INITCALL(mtk_infra_ao_init),
	INITCALL(mtk_pcie_init),
	INITCALL(mtk_mem_init),

	INITCALL(NULL)
};
