// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2023 MediaTek Inc. All Rights Reserved.
 *
 * Author: Weijie Gao <weijie.gao@mediatek.com>
 *
 * Dual FIP implementation
 */

#include <linux/errno.h>
#include <linux/string.h>
#include <u-boot/crc.h>
#include "colored_print.h"
#include "dual_fip.h"

static struct dual_fip_result dfipr;
static bool dfipr_valid;

bool dual_fip_boot_from_fip1(void)
{
	if (!dfipr_valid)
		return true;

	if (dfipr.fip_state[0] == DUAL_FIP_STATE_OK)
		return true;

	return false;
}

void dual_fip_read_result(void)
{
	u32 ocrc;

	memcpy(&dfipr, (void *)(CONFIG_TEXT_BASE - DUAL_FIP_RESULT_LEN),
	       DUAL_FIP_RESULT_LEN);

	ocrc = dfipr.crc;

	dfipr.crc = 0;
	dfipr.crc = crc32(0, (void *)&dfipr, DUAL_FIP_RESULT_LEN);

	if (dfipr.crc != ocrc) {
		cprintln(CAUTION,
		         "Warning: Dual-FIP checking result not passed by BL2");
		dfipr.ver = 0; /* Mark invalid */
		return;
	}

	if (dfipr.ver != DUAL_FIP_VER) {
		cprintln(ERROR,
		         "Error: Unsupported Dual-FIP checking result version");
		dfipr.ver = 0; /* Mark invalid */
		return;
	}

	/* Clear original data */
	memset((void *)(CONFIG_TEXT_BASE - DUAL_FIP_RESULT_LEN), 0,
	       DUAL_FIP_RESULT_LEN);

	dfipr_valid = true;
}
