
//#include <common.h>
#include <command.h>
#include <net.h>
#include "stop_boot.h"
#include "bootp.h"

#undef	ET_DEBUG
#define TARGET_PORT	23		/* monitor target port # */
#define CMP_STRING_SIZE	22	/* compare string size */

static int	ServerPort;		/* The UDP port at their end */
static int	OurPort;		/* The UDP port at our end */
static void STOP_BOOT_Handler (uchar * pkt, unsigned dest, unsigned src, unsigned len);
static void STOP_BOOT_Timeout (void);

extern int monitor_packet_result;

void STOP_BOOT_START(void){

#if defined(CONFIG_NET_MULTI)
	printf ("Using %s device\n", eth_get_name());
#endif
	puts ("listen from server ");	print_in_addr (net_server_ip.s_addr);
	puts ("; our IP address is ");	print_in_addr (net_ip.s_addr);
	putc ('\n');
	net_set_timeout_handler (6 * CONFIG_SYS_HZ, STOP_BOOT_Timeout);
	net_set_udp_handler(STOP_BOOT_Handler);
	ServerPort = 1024 + (get_timer(0) % 3072);
	OurPort = TARGET_PORT;
}

static void
STOP_BOOT_Handler (uchar * pkt, unsigned dest, unsigned src, unsigned len)
{
	volatile char udp_data[CMP_STRING_SIZE] = {0}; //ignor the last char(Line Feed)
	
	if (dest != OurPort) {
		return;
	}
//data compare if equal to chiron add monitor_packet_result

	if(len > CMP_STRING_SIZE)
		memcpy(udp_data,pkt,CMP_STRING_SIZE);
	else
		memcpy(udp_data,pkt,len);
	if(strcmp(udp_data,":chiron:chiron:chiron:")==0){
		printf(">>>Got STOP BOOT PACKET packet<<<\n");
		monitor_packet_result++;
		net_state = NETLOOP_SUCCESS;
	}
	else{
		return;
	}
}

static void
STOP_BOOT_Timeout (void)
{
	eth_halt();
	net_state = NETLOOP_FAIL;	/* we did not get specific packet */
}
