/*
 *	Copyright 1994, 1995, 2000 Neil Russell.
 *	(See License)
 *	Copyright 2000, 2001 DENX Software Engineering, Wolfgang Denk, wd@denx.de
 */

//#include <common.h>
#include <command.h>
#include <net.h>
#include <asm/byteorder.h>

#if defined(CONFIG_CMD_TELNETD)
#include <telnetd.h>
#endif

#include "uip/uipopt.h"
#include "uip/uip.h"
#include "uip/uip_arp.h"

#if defined(CONFIG_CMD_TELNETD)

#define TIMEOUT		5

extern void NetSendTelnetd(void);
extern void telnetd_init(void);
extern void shell_output(char *str1, char *str2);


static int arptimer = 0;

void
TelnetdHandler (void)
{
	int i;
	for(i = 0; i < UIP_CONNS; i++) {
		uip_periodic(i);
		if(uip_len > 0) {
			uip_arp_out();
			NetSendTelnetd();
		}
	}
	if(++arptimer == 20) {
		uip_arp_timer();
		arptimer = 0;
	}
}

#if 0
static void
TelnetdTimeout (void)
{
	puts ("T ");
	NetSetTimeout (TIMEOUT * 1000, TelnetdTimeout);
}
#endif

void
TelnetdStart (void)
{
	uip_init();
	telnetd_init();
}

int telnet_printf(const char *fmt, ...)
{
	/* Send to the stdout file */
	va_list args;
	char buf[TELNETD_CONF_LINELEN];
	int len;
	va_start(args, fmt);
	len = vsprintf(buf, fmt, args);
	va_end(args);
	shell_output(buf, "");
    return len;
}
#endif
